import { useEffect, useState } from "react";
import GuestLayout from "@/Layouts/GuestLayout";
import { Head, useForm } from "@inertiajs/react";
import Input from "@/Components/Form/Input";
import ShowPasswordButton from "@/Components/ShowPasswordButton";
import useFormChange from "@/utlis/useFormChange";

export default function Login(props) {
  const { status } = props;
  const { data, setData, post, processing, errors, reset } = useForm({
    email: "",
    password: "",
    remember: "",
  });

  useEffect(() => {
    return () => {
      reset("password");
    };
  }, []);

  function handleChange(e) {
    let { name, value } = useFormChange(e);

    setData((state) => ({
      ...state,
      [name]: value,
    }));
  }
  const submit = (e) => {
    e.preventDefault();

    post("/login");
  };

  const inputProps = { handleChange, data, errors };
  const [showPassword, setShowPassword] = useState(false);

  return (
    <GuestLayout>
      <Head title="Selamat Datang" />
      <p className="text-5xl font-bold text-center text-white ">
        Login
      </p>

      {status && (
        <div className="mb-4 text-sm font-medium text-green-600">{status}</div>
      )}
      {props.flash?.message ? (
        <div className="h-full mx-auto mb-4 text-center text-white badge badge-error">
          {props.flash?.message}
        </div>
      ) : null}

      <form onSubmit={submit} className="flex flex-col space-y-5" >

        <div className="relative flex items-center gap-2 border-b-2 border-white ">
          <i className="fas fa-user text-lg text-white"></i>

          <Input isLabel={false} type="text" name="email" label="Email" placeHolder="Email"
            className="w-full  border-white  bg-transparent placeholder-white  h-12 transparent-input text-white"
            {...inputProps} />
        </div>
        <div className="relative flex items-center gap-2 border-b-2  border-white ">

          <i className="fas fa-lock  text-lg text-white"></i>

          <Input isLabel={false} type={showPassword ? 'text' : 'password'} name='password' label='password' {...inputProps} placeHolder="Password"
            className="w-full  border-white  bg-transparent placeholder-white h-12 transparent-input text-white"
          />
          <ShowPasswordButton show={showPassword} setShow={setShowPassword} className = 'cursor-pointer' />
        </div>

        <div className="flex flex-col gap-4 my-4">
          <div className="flex flex-col">
            <button
              className="h-12 bg-gradient-to-t from-[#0C6A93] to-[#0399DB] rounded-full text-xl font-semibold border-2 border-[#0399DB] text-white cursor-pointer transform hover:scale-105 transition-transform duration-300 ease-in-out"
              disabled={processing}
            >
              Masuk
            </button>

          </div>
        </div>



      </form>
    </GuestLayout>
  );
}
