import Guest from "@/Layouts/GuestLayout"
import { Link, Head } from "@inertiajs/react"
import axios from "axios"
import { useState } from "react"

export default function Home(props) {
  const [text, setText] = useState({
    from: {
      lang: "id",
      content: null
    },
    to: {
      lang: "zh-CN",
      content: null
    }
  })

  const handleTextChange = (e) => {
    setText({
      ...text,
      from: {
        lang: text.from.lang,
        content: e.target.value
      },
      to: {
        lang: text.to.lang,
        content: null
      }
    })
  }

  const handleTextProcessing = async () => {
    const { data } = await axios({
      baseURL: props.translateBaseUrl,
      method: "POST",
      url: "translate",
      data: {
        lang_from: text.from.lang,
        lang_to: text.to.lang,
        text: text.from.content
      }
    })
    if (data.payload.data.text) {
      setText({
        ...text,
        to: {
          lang: text.to.lang,
          content: data.payload.data.text
        }
      })
    }
  }

  return (
    <Guest>
      <Head title="Laravel">
     
      </Head>
      <div className="flex flex-col items-center justify-center gap-4">
        <div className="w-full flex flex-col items-center">
          <p className="font-semibold self-start">Text Translation</p>
          <input
            placeholder="Enter to translate"
            onKeyDown={(e) => (e.code == "Enter" ? handleTextProcessing() : null)}
            type="text"
            onChange={handleTextChange}
            onBlur={handleTextProcessing}
            className="input input-bordered w-full"
          />
        </div>
        <div className="flex gap-4 flex-wrap items-center justify-center">
          {text.from.content ? (
            <div className="text-center">
              <p className="font-semibold uppercase">{text.from.lang}</p>
              <p className="text-2">{text.from.content}</p>
            </div>
          ) : null}
          {text.to.content && text.from.content ? (
            <div className="text-center">
              <p className="font-semibold uppercase">{text.to.lang}</p>
              <p className="text-2">{text.to.content}</p>
            </div>
          ) : null}
        </div>

        <div className="flex gap-2">
          <Link href="/login" className="btn btn-sm btn-primary">
            Login
          </Link>
          <Link href="/register" className="btn btn-sm btn-primary btn-outline">
            Register
          </Link>
        </div>
      </div>
    </Guest>
  )
}
