import HomeLayout from "@/Layouts/HomeLayout"

import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"
import React, { useEffect, useState } from "react"

import "../Home/styles.css"
import CTA from "@/Components/CTA"
import useLang from "@/utlis/useLang"
import FadeIn from "@/Components/animation/FadeIn"
import { date } from "@/utlis/format"
import { IoIosArrowForward, IoIosArrowBack, IoIosArrowRoundForward } from "react-icons/io"
import useButtonTitle from "@/utlis/useButtonTitle"

const Index = (props) => {
  const location = props.location
    const title = useButtonTitle()

  return (
    <HomeLayout>
      <div className="bg-gradient-to-bl from-[#daf0fa] to-transparent">

        <div className="flex flex-col items-center justify-center h-[20vh] lg:h-[50vh] max-h-[720px]">
          <Hero title={props.title} />
        </div>

        <div className=" flex flex-col items-center justify-center  lg:min-h-screen 3xl:min-h-full max-w-screen-2xl mx-auto">
          <BlogList content={props.blogs} location={location} />
        </div>
      
              <div className="flex flex-col items-center justify-center ">
          <CTA />
        </div>
      </div>
    </HomeLayout>
  )
}

export default Index

function Hero({ title }) {
  return (
    <>
      <div
        className="relative w-full h-screen bg-cover md:bg-fixed  bg-center"
        style={{
          backgroundImage: "url('/image/bg/bg-artikel.jpg')",
          backgroundPosition: "center"
        }}
      >
        <div className="absolute inset-0 bg-[#0399DB] bg-opacity-70"></div>

        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse px-10 lg:px-40 pb-5 lg:pb-20 z-10 max-w-screen-2xl mx-auto">
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <h1 className="h1_hero text-white z-10 font-bold">{title}</h1>
          </FadeIn>
        </div>

      </div>
    </>
  )
}

function BlogList({ content, location, title }) {
  

const cleanUrl = location.replace(/\/category\/[^/]+/, '');


  return (
    <div className=" relative text-black p-5 md:py-10 lg:py-20 lg:px-40 md:px-10 ">
      <div className="absolute inset-0 hidden md:block bg-white mx-5 md:my-5 lg:mx-36 lg:my-20 rounded-lg"></div>

      <div className="relative ">
        <div className="flex flex-col lg:py-10 flex-1 py-2  w-full gap-1">
          {content.data.map((article, index) => (
            <FadeIn style={"h-full w-full"}>
              <a
              title={`${title}`}
                 href={`${cleanUrl}/${article.slug}`}
                key={index}
                className="bg-white cursor-pointer mb-7 group border flex-1 w-full flex flex-col md:flex-row lg:h-40 2xl:h-52 rounded-md lg:rounded-xl p-1 lg:p-2 transition-all duration-300"
            >
              {/* Thumbnail */}
              <div className="w-full md:h-full lg:h-auto lg:w-1/4 lg:group-hover:w-0 2xl:group-hover:w-0 transition-all duration-300 aspect-[16/9] md:aspect-auto bg-slate-300 rounded-tl-md rounded-bl-md lg:rounded-tr-none lg:rounded-br-none overflow-hidden">
                <img src={article.thumbnail} alt="article.thumbnail" className="h-full w-full object-cover" />
              </div>

              {/* Content */}
              <div className="w-full lg:w-3/4  flex flex-col p-1 gap-3 md:px-3 transition-all duration-300">
                <h3 className="h3 text-left ">{article.title}</h3>
                <p className="p text-left text-[#7C7C7C] text-ellipsis">{article.short_description}</p>
                <p className="p text-right text-[#7C7C7C] mt-auto">{date(article.published_at)}</p>
              </div>

              {/* Hover Section */}
              <div className="hidden w-0 lg:group-hover:w-1/4 transition-all duration-300 bg-gradient-to-l from-[#a5e4ff] to-transparent lg:flex justify-center items-center rounded-tl-md rounded-bl-md overflow-hidden">
                <p className="opacity-0 lg:group-hover:opacity-100 translate-x-[100%] lg:group-hover:translate-x-0 p font-semibold text-[#0399DB] lg:px-3 lg:py-2 lg:rounded-md transition-all duration-300">
                  {useLang("home.Article.read-all_button")}
                </p>
              </div>
            </a>
            </FadeIn>
          ))}
        </div>

          <div className="py-5">
        <Pagination content={content} />

          </div>
      </div>
    </div>
  )
}

function Pagination({ content , title }) {
  const [pageWindowStart, setPageWindowStart] = useState(0)
  const pageWindowSize = 5

  const currentPage = content.current_page

  // Get only the page number links (skip prev/next)
  const pageLinks = content.links.slice(1, content.links.length - 1)

  // Move the window if currentPage is outside visible range
  useEffect(() => {
    const currentIndex = pageLinks.findIndex((link) => link.label == currentPage)
    if (currentIndex < pageWindowStart || currentIndex >= pageWindowStart + pageWindowSize) {
      setPageWindowStart(Math.max(0, currentIndex - 2)) // center current
    }
  }, [currentPage])

  const visibleLinks = pageLinks.slice(pageWindowStart, pageWindowStart + pageWindowSize)

  return (
    <div className="h-full w-full flex justify-center items-center text-black">
      <div className="flex lg:gap-2 items-center">
        {/* Prev Button (first index) */}
        <a
        title={`${title}`}
          href={content.links[0].url || "#"}
          className={`flex justify-center px-3 items-center rounded-sm cursor-pointer bg-[#0399DB] shadow-md hover:bg-white border md:border-2 border-[#0399DB] hover:text-[#0399DB] transition-all duration-300 text-white md:p-2 lg:rounded-md font-semibold ${
            content.current_page === 1 ? "opacity-50 pointer-events-none" : ""
          }`}
          dangerouslySetInnerHTML={{ __html: content.links[0].label }}
        />

        {/* Visible Page Numbers */}
        {visibleLinks.map((link, index) => (
          <a
          title={`${title}`}
            href={link.url || "#"}
            key={index}
            className={`flex justify-center px-2 md:px-3 items-center rounded-sm cursor-pointer hover:text-[#0399DB] ${
              link.active ? "text-[#0399DB] font-bold scale-125" : ""
            }`}
            dangerouslySetInnerHTML={{ __html: link.label }}
          />
        ))}

        {/* Next Button (last index) */}
        <a
        title={`${title}`}
          href={content.links[content.links.length - 1].url || "#"}
          className={`flex justify-center px-3 items-center rounded-sm cursor-pointer bg-[#0399DB] shadow-md hover:bg-white border md:border-2 border-[#0399DB] hover:text-[#0399DB] transition-all duration-300 text-white md:p-2 lg:rounded-md font-semibold ${
            content.current_page === content.last_page ? "opacity-50 pointer-events-none" : ""
          }`}
          dangerouslySetInnerHTML={{
            __html: content.links[content.links.length - 1].label
          }}
        />
      </div>
    </div>
  )
}
