import HomeLayout from "@/Layouts/HomeLayout"

import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"
import React, { useState } from "react"

import "../Home/styles.css"
import CTA from "@/Components/CTA"
import useLang from "@/utlis/useLang"
import FadeIn from "@/Components/animation/FadeIn"
import { date } from "@/utlis/format"
import { SwiperSlide, Swiper } from "swiper/react"
import { Autoplay, Navigation, Pagination } from "swiper/modules"
import { IoIosArrowForward, IoIosArrowBack, IoIosArrowRoundForward } from "react-icons/io"
import { usePage } from "@inertiajs/react"
import useButtonTitle from "@/utlis/useButtonTitle"

const Index = (props) => {
  const location = props.location
  const title = useButtonTitle()


  return (
    <HomeLayout>
      <div className="bg-[#daf0fa] relative">
        <div
          className="absolute inset-0  bg-cover bg-center bg-no-repeat  bg-fixed"
          style={{
            backgroundImage: "url('/image/bg/bg-artikel.jpg')"
          }}
        ></div>
        <div className="flex flex-col items-center justify-center h-[20vh] lg:h-[50vh] max-h-[720px]">
          <Hero />
        </div>

        <div className="  flex flex-col  items-center justify-center relative">
          <div className="h-full py-5 px-5 md:px-10 lg:px-40 w-full flex flex-col  items-center justify-center bg-white shadow-custom lg:py-10">
            <FeaturedBlogs content={props.featuredBlogs} location={location} title={title} />
          </div>
        </div>



        <div className="flex flex-col items-center justify-center  lg:min-h-screen 3xl:min-h-full relative ">
          <div className="absolute inset-0  bg-gradient-to-b from-[#daf0fa] to-transparent"></div>
          <BlogCategory content={props.categories} location={location} title={title} />
        </div>

        <div className="flex flex-col items-center justify-center">
          <CTA />
        </div>
      </div>
    </HomeLayout>
  )
}

export default Index

function Hero() {
  return (
    <>

      <div className="relative w-full h-screen flex justify-center bg-[url('/image/bg/bg-artikel.jpg')] bg-cover bg-center lg:bg-none"


        >
        <div className="absolute inset-0 bg-[#0399DB] bg-opacity-70"></div>
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse px-10 max-w-screen-2xl lg:px-40 pb-5 lg:pb-20 z-10 absolute"></div>

        {/* Your content */}
      </div>
    </>
  )
}

function FeaturedBlogs({ content, location, title }) {
  const { props } = usePage()

  return (
    <div className=" text-black w-full flex max-w-screen-xl flex-col items-center ">
      <div className="py-2 lg:py-3 flex w-full justify-between items-center">
        <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
          <h1 className="h1">{props?.featuredCategory?.name}</h1>
        </FadeIn>

        <div className="hidden lg:flex">
          <div className="prev-test-featured cursor-pointer  ">
            <IoIosArrowBack className=" text-xl sm:text-5xl lg:text-5xl text-[#0399DB] hover:scale-110" />
          </div>
          <div className="next-test-featured cursor-pointer  ">
            <IoIosArrowForward className="text-xl sm:text-5xl lg:text-5xl text-[#0399DB] hover:scale-110" />
          </div>
        </div>
      </div>

      <div className="flex flex-col  flex-1   w-full gap-1 lg:gap-5 ">
        <Swiper
          autoplay={{
            delay: 4000,
            disableOnInteraction: false,
            pauseOnMouseEnter: true
          }}
          pagination={{
            clickable: true,
            dynamicBullets: true
          }}
          navigation={{
            nextEl: ".next-test-featured",
            prevEl: ".prev-test-featured"
          }}
          spaceBetween={20}
          slidesPerView={1}
          modules={[Navigation, Autoplay, Pagination]}
          className="w-full"
        >
          {content.map((article, index) => (
            <SwiperSlide key={index}>
              <a
              href={`/blog/${article.slug}`}
              key={index}
              title={`${title}`}
              className="bg-white cursor-pointer mb-7 group border flex-1 w-full flex flex-col md:flex-row lg:h-40 2xl:h-52 rounded-md lg:rounded-xl p-1 lg:p-2 transition-all duration-300"
            >
              {/* Thumbnail */}
              <div className="w-full md:h-full lg:h-auto lg:w-1/4 lg:group-hover:w-0 2xl:group-hover:w-0 transition-all duration-300 aspect-[16/9] md:aspect-auto bg-slate-300 rounded-tl-md rounded-bl-md lg:rounded-tr-none lg:rounded-br-none overflow-hidden">
                <img src={article.thumbnail} alt="article.thumbnail" className="h-full w-full object-cover" />
              </div>

              {/* Content */}
              <div className="w-full lg:w-3/4  flex flex-col p-1 gap-3 md:px-3 transition-all duration-300">
                <h3 className="h3 text-left ">{article.title}</h3>
                <p className="p text-left text-[#7C7C7C] text-ellipsis">{article.short_description}</p>
                <p className="p text-right text-[#7C7C7C] mt-auto">{date(article.published_at)}</p>
              </div>

              {/* Hover Section */}
              <div className="hidden w-0 lg:group-hover:w-1/4 transition-all duration-300 bg-gradient-to-l from-[#a5e4ff] to-transparent lg:flex justify-center items-center rounded-tl-md rounded-bl-md overflow-hidden">
                <p className="opacity-0 lg:group-hover:opacity-100 translate-x-[100%] lg:group-hover:translate-x-0 p font-semibold text-[#0399DB] lg:px-3 lg:py-2 lg:rounded-md transition-all duration-300">
                  {useLang("home.Article.read-all_button")}
                </p>
              </div>
            </a>
            </SwiperSlide>
          ))}
        </Swiper>
        <div className="flex w-full lg:hidden justify-between items-center">
          <div className={`prev-test-featured cursor-pointer `}>
            <IoIosArrowBack className=" text-2xl text-[#0399DB] hover:scale-110" />
          </div>
          <div className={`next-test-featured cursor-pointer `}>
            <IoIosArrowForward className="text-2xl text-[#0399DB] hover:scale-110" />
          </div>
        </div>
      </div>
    </div>
  )
}

function BlogCategory({ content, location, title }) {

  return (
    <div className=" relative text-black px-5 md:py-10 lg:py-20 lg:px-40 md:px-10 ">
      <div className="absolute inset-0 hidden md:block bg-white mx-5 md:my-5 lg:mx-36 lg:my-20 rounded-lg"></div>

      <div className="relative ">
        {content.map((category, index) => (
          <div key={index}>
            <div className="py-2 pt-10 lg:py-5 flex  justify-between    border-b-2 border-black items-center">
              <h2 className="h1"> {category.name} </h2>



            </div>
            <div className="flex flex-col lg:py-10 flex-1 py-2 px-1 max-w-screen-xl w-full gap-1   ">
              {category.blog.map((article, index) => (
                <FadeIn style={"h-full w-full"} key={index}>
                <a
              href={`/blog/${article.slug}`}
              key={index}
              title={`${title}`}
              className="bg-white cursor-pointer mb-7 group border flex-1 w-full flex flex-col md:flex-row lg:h-40 2xl:h-52 rounded-md lg:rounded-xl p-1 lg:p-2 transition-all duration-300"
             >
              {/* Thumbnail */}
              <div className="w-full md:h-full lg:h-auto lg:w-1/4 lg:group-hover:w-0 2xl:group-hover:w-0 transition-all duration-300 aspect-[16/9] md:aspect-auto bg-slate-300 rounded-tl-md rounded-bl-md lg:rounded-tr-none lg:rounded-br-none overflow-hidden">
                <img src={article.thumbnail} alt="article.thumbnail" className="h-full w-full object-cover" />
              </div>

              {/* Content */}
              <div className="w-full lg:w-3/4  flex flex-col p-1 gap-3 md:px-3 transition-all duration-300">
                <h3 className="h3 text-left ">{article.title}</h3>
                <p className="p text-left text-[#7C7C7C] text-ellipsis">{article.short_description}</p>
                <p className="p text-right text-[#7C7C7C] mt-auto">{date(article.published_at)}</p>
              </div>

              {/* Hover Section */}
              <div className= "hidden w-0 lg:group-hover:w-1/4  transition-all duration-300 bg-gradient-to-l from-[#a5e4ff] to-transparent lg:flex justify-center items-center rounded-tl-md rounded-bl-md overflow-hidden">
                <p className="opacity-0 lg:group-hover:opacity-100 translate-x-[100%] lg:group-hover:translate-x-0 p font-semibold text-[#0399DB] lg:px-3 lg:py-2 lg:rounded-md transition-all duration-300">
                  {useLang("home.Article.read-all_button")}
                </p>
              </div>
            </a>
                </FadeIn>



              ))}
               <div className="flex items-center justify-center w-full    mb-5 lg:mb-0">

        <a title={`${title}`} href={`/blog/category/${category.slug}`} className="bg-[#0399DB] text-white px-4 py-2 rounded-md h3 hover:bg-white border-2 border-[#0399DB] hover:text-[#0399DB] transition-all duration-200">
          {useLang("home.Article.see-all_button")}
        </a>

        </div>
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}

