import HomeLayout from "@/Layouts/HomeLayout"

import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"
import React, { useState, useRef, useEffect } from "react"

import "../Home/styles.css"
import CTA from "@/Components/CTA"
import useLang from "@/utlis/useLang"
import FadeIn from "@/Components/animation/FadeIn"
import { date } from "@/utlis/format"
import { SwiperSlide, Swiper } from "swiper/react"
import { Autoplay, FreeMode, Navigation, Pagination, Thumbs } from "swiper/modules"
import { IoIosArrowForward, IoIosArrowBack, IoIosArrowRoundForward } from "react-icons/io"
import useButtonTitle from "@/utlis/useButtonTitle"

const Index = (props) => {
  const location = props.location
  const title = useButtonTitle()



  return (
    <HomeLayout>
      <div className="">
        <div className="flex flex-col items-center justify-center h-[40vh] lg:h-[90vh] max-h-[720px]">
          <Hero content={props.blog} />
        </div>

        <div className="hidden lg:flex  justify-center lg:gap-5 lg:px-20  lg:py-10 max-w-screen-2xl mx-auto">
          <div className="w-3/4 flex flex-col max-w-screen-2xl items-center justify-center md:minh-[40vh] lg:min-h-screen 3xl:min-h-full  ">
            <BlogDetail content={props.blog} />
          </div>
          <div className="w-1/4 flex flex-col max-w-screen-2xl items-center justify-center  sm:min-h-[20vh] lg:min-h-full  ">
            <RelatedBlogs content={props.relatedBlogs} location={location} title={title} />
          </div>
        </div>

        {/* mobile */}
        <div className="lg:hidden flex-col  justify-center lg:gap-5 lg:px-20  lg:py-10">
          <div className=" flex  flex-col items-center justify-center   ">
            <BlogDetailMobile content={props.blog} />
          </div>

          <div className="  flex flex-col items-center justify-center h-[30vh] sm:min-h-[20vh] lg:h-[60vh] lg:my-10  lg:px-40">
            <RelatedBlogsMobile content={props.relatedBlogs} location={location} title={title} />
          </div>
        </div>
      </div>

      <div className="flex flex-col items-center justify-center">
        <CTA />
      </div>
    </HomeLayout>
  )
}

export default Index

function Hero({ content }) {
  return (
    <>
      <div
        className="relative flex justify-center w-full h-screen bg-cover bg-blend-multiply bg-center   "
        style={{
          backgroundImage: `url(${content.thumbnail})`,
          backgroundPosition: "center",
          backgroundSize: "cover",
          backgroundRepeat: "no-repeat"
        }}
      >
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="absolute inset-0 bg-gradient-to-t from-black to-transparent mix-blend-multiply"></div>

        <div className="h-full w-full flex flex-col-reverse max-w-screen-2xl px-4 lg:px-40 pb-5 gap-2 lg:pb-20 z-10 absolute">
          <FadeIn direction="horizontal" duration={0.6} delay={0.4}>
            <div className="flex flex-col lg:gap-5">
              <div className=" p mt-auto">{date(content.published_at)}</div>
            </div>
          </FadeIn>
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <h1 className="h1 text-white z-10">{content.title}</h1>
          </FadeIn>
        </div>

        {/* Your content */}
      </div>
    </>
  )
}

function BlogDetail({ content }) {
  const [thumbsSwiper, setThumbsSwiper] = useState(null)
  const [activeIndex, setActiveIndex] = useState(0)

  useEffect(() => {
    if (thumbsSwiper && activeIndex != null) {
      thumbsSwiper.slideToLoop(activeIndex);
    }
  }, [activeIndex, thumbsSwiper]);

  const fontSizeStyle = `
[&_p]:text-black
[&_p]:p
[&_h3]:h2
[&_h4]:h3
[&_p]:p
[&_ol]:p
[&_p]:text-justify
`

  return (
    <div className="h-full w-full  text-black">
      {!!content?.is_slider && content?.blog_image?.length > 0 ? (
        <div className={`flex flex-col flex-1 md:h-[40vh]  lg:h-[80vh] 2xl:max-h-[920px] gap-1 lg:gap-5`}>
          <FadeIn style={`flex  flex-col h-full`}>
            <div className="h-3/4 w-full border lg:rounded-md overflow-hidden">
              {/* Main Swiper */}
              <Swiper
                spaceBetween={10}
                slidesPerView={1}
                loop={true}
                autoplay={{
                  delay: 4000,
                  disableOnInteraction: false
                }}
                thumbs={{ swiper: thumbsSwiper }}
                modules={[Navigation, Thumbs, Autoplay]}
                onSlideChange={(swiper) => setActiveIndex(swiper.realIndex)}
                className="rounded-xl overflow-hidden"
              >
                {content.blog_image.map((item, index) => (
                  <SwiperSlide key={index}>
                    <img src={item.value} alt={`Slide ${index}`} className="w-full h-auto border object-cover" />
                  </SwiperSlide>
                ))}
              </Swiper>
            </div>
            <div className="h-1/4  p-5 mr-auto w-full">
              {/* Thumbnail Swiper */}
              <Swiper
                onSwiper={setThumbsSwiper}
                loop={true}
                spaceBetween={0}
                watchSlidesProgress={true}
                allowTouchMove={false}
                slidesPerView={'auto'}
                modules={[Navigation]}
              >
                {content.blog_image.map((item, index) => (
                  <SwiperSlide key={index} className="h-full w-full max-w-[180px]  aspect-square">
                    <div
                      className={`relative  aspect-square h-full cursor-pointer border  lg:rounded-md overflow-hidden ${index === activeIndex ? "border-4 border-[#0399DB]" : ""}`}
                    >
                      <img src={item.value} alt={`Thumb ${index}`} className="w-full h-full object-cover " />
                      <div
                        className={`absolute inset-0 bg-black transition-opacity duration-300 ${index === activeIndex ? "opacity-40" : "opacity-0"}`}
                      />
                    </div>
                  </SwiperSlide>
                ))}
              </Swiper>
            </div>
          </FadeIn>
        </div>
      ) : null}
      <FadeIn>
        <div className="flex lg:gap-10 flex-col lg:p-10  bg-white lg:rounded-xl  shadow-md">
          <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: content.description }}></div>
        </div>
      </FadeIn>
    </div>
  )
}

function RelatedBlogs({ content, location, title }) {
  const fullUrl = location
  const baseUrl = fullUrl.split("/").slice(0, 4).join("/")

  return (
    <div className=" flex lg:gap-5 h-full flex-col w-full">
      <div className="h-14 text-black  border-b-2 border-black">
        <h2 className="text-black h2">{useLang("blog.RelatedBlogs.label")}</h2>
      </div>

      {content.map((item, index) => (
        <FadeIn direction="horizontal" key={index}>
          <a
            title={`${title}`}
            href={`${baseUrl}/${item.slug}`}
            className="flex flex-col-reverse group bg-white shadow-md lg:p-2 lg:rounded-md h-[25vh] max-h-[480px] text-white text-xl font-bold relative overflow-hidden"
            style={{
              backgroundImage: `url(${item.thumbnail})`,
              backgroundPosition: "center",
              backgroundSize: "cover",
              backgroundRepeat: "no-repeat"
            }}
          >
            <div className="absolute inset-0 bg-gradient-to-t from-black to-transparent group-hover:from-[#064D6C] group-hover:bg-opacity-60 group-hover:bg-[#0399DB] transition-all duration-500"></div>
            <div className="p z-10 font-light text-left  text-[#ffffff] ">{date(item.published_at)}</div>
            <h1 className="p text-white text-left self-end z-10 font-bold  ">{item.title}</h1>
          </a>
        </FadeIn>
      ))}
    </div>
  )
}

// mobile Version

function BlogDetailMobile({ content }) {
  const fontSizeStyle = `
  [&_p]:text-black
  
  [&_ol]:p
  [&_p]:p
  [&_p]:text-justify
`

  const [thumbsSwiper, setThumbsSwiper] = useState(null)
  const [activeIndex, setActiveIndex] = useState(0)

  useEffect(() => {
    if (thumbsSwiper && activeIndex != null) {
      thumbsSwiper.slideToLoop(activeIndex);
    }
  }, [activeIndex, thumbsSwiper]);

  return (
    <div className="h-full w-full p-5 text-black ">
      <div className="flex flex-col lg:px-40 lg:py-10 flex-1 py-2  h-full w-full gap-1 lg:gap-5   ">
        {!!content?.is_slider && content?.blog_image?.length > 0 ? (
          <div className="flex flex-col flex-1  h-full w-full gap-1 lg:gap-5   ">
            <FadeIn>
              <div className="h-[30vh] w-full border rounded-md overflow-hidden">
                <Swiper
                  spaceBetween={10}
                  slidesPerView={1}
                  loop={true}
                  autoplay={{
                    delay: 4000,
                    disableOnInteraction: false
                  }}
                  thumbs={{ swiper: thumbsSwiper }}
                  modules={[Navigation, Thumbs, Autoplay]}
                  onSlideChange={(swiper) => setActiveIndex(swiper.realIndex)}
                  className="rounded-md overflow-hidden"
                >
                  {content.blog_image.map((item, index) => (
                    <SwiperSlide key={index}>
                      <img src={item.value} alt={`Slide ${index}`} className="w-full h-auto  border object-cover" />
                    </SwiperSlide>
                  ))}
                </Swiper>
              </div>
              <div className="h-28 mr-auto py-5 ">
                {/* Thumbnail Swiper */}
                <Swiper
                  onSwiper={setThumbsSwiper}
                  loop={true}
                  spaceBetween={0}
                  watchSlidesProgress={true}
                  allowTouchMove={false}
                  slidesPerView={'auto'}
                  modules={[Navigation]}
                >
                  {content.blog_image.map((item, index) => (
                    <SwiperSlide key={index} className="h-full max-w-[80px] aspect-square">
                      <div
                        className={`relative aspect-square h-full cursor-pointer border  rounded-md overflow-hidden ${index === activeIndex ? "border-4 border-[#0399DB]" : ""}`}
                      >
                        <img src={item.value} alt={`Thumb ${index}`} className="w-full h-full object-cover " />
                        <div
                          className={`absolute inset-0 bg-black transition-opacity duration-300 ${index === activeIndex ? "opacity-10" : "opacity-0"}`}
                        />
                      </div>
                    </SwiperSlide>
                  ))}
                </Swiper>
              </div>
            </FadeIn>
          </div>
        ) : null}
        <FadeIn>
          <div className="flex lg:gap-10 flex-col lg:p-10lg:rounded-xl  ">
            <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: content.description }}></div>
          </div>
        </FadeIn>
      </div>
    </div>
  )
}

function RelatedBlogsMobile({ content, location, title }) {


  const fullUrl = location
  const baseUrl = fullUrl.split("/").slice(0, 4).join("/")
  return (
    <div className="relative h-full p-5 w-full  mb-5">
      {/* Navigation buttons */}



      <Swiper
        spaceBetween={10}
        slidesPerView={1.5}
        loop={true}
        navigation={{
          nextEl: ".next-related",
          prevEl: ".prev-related"
        }}
        pagination={{ clickable: true }}
        modules={[Autoplay, Navigation, Pagination]}
        autoplay={{
          delay: 3000,
          disableOnInteraction: false
        }}
        className="custom-swiper-pagination"
      >
        {content.map((item, index) => (
          <SwiperSlide key={index}>

            <a
              title={`${title}`}
              href={`${baseUrl}/${item.slug}`}
              className="flex flex-col-reverse rounded  bg-white shadow-lg p-1 lg:p-2 lg:rounded-md h-full text-white text-xl font-bold relative overflow-hidden"
              style={{
                backgroundImage: `url(${item.thumbnail})`,
                backgroundPosition: "center",
                backgroundSize: "cover",
                backgroundRepeat: "no-repeat"
              }}
            >
              <div className="absolute inset-0 bg-gradient-to-t from-black to-transparent mix-blend-multiply"></div>
              {/* <div className=" text-[8px] sm:text-xs lg:text-sm z-10 font-light text-left  text-[#ffffff] ">Published {date(item.published_at)}</div> */}
              <p className="text-xs text-white text-left z-10 font-bold ">{item.title}</p>
            </a>
          </SwiperSlide>
        ))}
      </Swiper>

      <div className="flex  px-20 py-2 justify-between ">
        <button className="prev-related">
          <IoIosArrowBack className=" text-xl text-[#0399DB]" />
        </button>
        <button className="next-related">
          <IoIosArrowForward className="text-xl text-[#0399DB]" />
        </button>
      </div>
    </div>
  )
}
