import HomeLayout from "@/Layouts/HomeLayout"

import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"
import React, { useState } from "react"
import { IoIosArrowForward, IoIosArrowBack } from "react-icons/io"

import "../Home/styles.css"
import CTA from "@/Components/CTA"
import useLang from "@/utlis/useLang"
import FadeIn from "@/Components/animation/FadeIn"
import useButtonTitle from "@/utlis/useButtonTitle"

const Index = (props) => {
  const title = useButtonTitle()
  const fontSizeStyle = `
[&_p]:text-black
[&_]:p
[&_p]:text-justify
`

  return (
    <HomeLayout>
      <div className="flex flex-col items-center justify-center h-[20vh] lg:h-[50vh] max-h-[720px]">
        <Hero />
      </div>

      <div className="px-10 lg:px-40 flex flex-col items-center justify-center  lg:min-h-[70vh] 2xl:min-h-full max-h-[1440px] max-w-[80rem] mx-auto mt-8">
        <CategoryList content={props} title={title} />
      </div>

      <div className="flex flex-col items-center justify-center mt-20">
        <CTA />
      </div>
    </HomeLayout>
  )
}

export default Index

function Hero() {
  const smallDevices = (window.innerWidth >= 768 && window.innerWidth < 1024) || window.innerWidth < 768
  const bgPosition = smallDevices ? "center" : "center top -155px"

  return (
    <>
      <div
        className="relative w-full h-screen flex justify-center lg:bg-fixed bg-cover bg-center bg-[#0399DB] bg-blend-luminosity"
        style={{
          backgroundImage: "url('image/bg/City-line.webp')",
          backgroundPosition: bgPosition
        }}
      >
        {/* Dark semi-transparent overlay */}
        <div className="absolute inset-0 bg-[#0399DB] opacity-50 "></div>
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse px-10 lg:px-40 pb-5 lg:pb-20 z-10 absolute max-w-[80rem]">
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <h1 className="h1_hero text-white z-10 font-bold">{useLang("category.title")}</h1>
          </FadeIn>
        </div>

        {/* Your content */}
      </div>
    </>
  )
}

function CategoryList({ content, title }) {
  const [openIndex, setOpenIndex] = useState(null)

  const fontSizeStyle = `
  [&_p]:lg:text-white
  [&_p]:p
  [&_p]:text-justify
`

 const [squareImages, setSquareImages] = useState({}) // Track which idx is square

  const handleImageLoad = (e, idx) => {
    const { naturalWidth, naturalHeight } = e.target
    setSquareImages((prev) => ({
      ...prev,
      [idx]: naturalWidth === naturalHeight,
    }))
  }


  const products = content.categories

  return (
    <div className="h-full">
      <div className="  w-full pb-10 flex flex-col md:flex-row gap-5 lg:gap-5">
        {products.map((product, index) => (
          <div
            key={index}
            className="bg-white relative group  custom-shadow min-h-96  justify-between w-full lg:h-auto lg:w-full flex flex-col lg:rounded-lg overflow-hidden"
          >
            <div className=" h-full w-full absolute inset-0 bg-blend-multiply opacity-5 lg:py-auto">
              <img src="/image/texture/side_tech.webp" alt="" className="object-cover h-full" />
            </div>

            <div className={`lg: p-2 gap-5 w-full flex flex-col-reverse `}>
              <div
                className={`${openIndex === index ? "translate-x-[-120%] scale-0" : "translate-x-0"} w-full scale-75 lg:scale-100 lg:w-full z-10 lg:group-hover:blur-sm transition-all   duration-500  lg:p-5`}
              >
                <img src={product.thumbnail} alt={product.title}
                
                  onLoad={(e) => handleImageLoad(e, index)}
                className="aspect-square w-full object-contain rounded"/>
              </div>
              <h3
                className={`${openIndex === index ? "translate-x-[-120%] scale-0" : "translate-x-0"} text-[#0399DB] z-10 lg:h-20 lg:group-hover:blur-sm transition-all   duration-500 flex justify-center items-center h3`}
              >
                {product.name}
              </h3>
            </div>

            <div
              className={`${openIndex === index ? "translate-x-0 " : "translate-x-[100%] scale-50 "} absolute pt-5 md:pt-5 lg:hidden flex-1  h-full w-full transition-all   duration-500 px-5  text-base lg:min-h-10 text-black `}
            >
              <div className={`text-editor-content ${fontSizeStyle}`} dangerouslySetInnerHTML={{ __html: product.description }}></div>
            </div>

            <div className="hidden lg:block flex-1 z-10 lg:px-5 h-full w-full absolute lg:p-5 opacity-0  translate-y-[-100%]  group-hover:translate-y-0  group-hover:opacity-100 transition-all   duration-500 bg-black bg-opacity-80  lg:text-xl lg:min-h-10 text-black ">
              <div className={`text-editor-content ${fontSizeStyle}`} dangerouslySetInnerHTML={{ __html: product.description }}></div>
            </div>
            <div className="p-2 lg:p-5 z-10 lg:h-20 flex flex-col justify-center gap-1 items-center ">
              <button
                onClick={() => setOpenIndex(openIndex === index ? null : index)}
                className="bg-white shadow-md h-full w-full h3 self-end lg:hidden flex justify-center items-center rounded-md cursor-pointer font-bold text-[#0399DB]  border-2 border-[#0399DB]  hover:scale-105 transition-all duration-300"
              >
                {openIndex === index ? "" : <IoIosArrowBack />} {useLang("category.CategoryList.description_btn")}{" "}
                {openIndex === index ? <IoIosArrowForward /> : ""}
              </button>
              <a
                title={`${title}`}
                href={`${content.location}/${product.slug}`}
                className="bg-[#0399DB] shadow-md h-full w-full self-end h3 rounded-md lg:rounded-md flex justify-center items-center cursor-pointer font-bold text-white hover:bg-white border-2 border-[#0399DB] hover:text-[#0399DB] hover:scale-105 transition-all duration-300"
              >
                {useLang("category.categoryList.see_btn")}
              </a>
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}
