import HomeLayout from "@/Layouts/HomeLayout"

import "../Home/styles.css"

import { FaPhone } from "react-icons/fa6"
import FadeIn from "@/Components/animation/FadeIn"
import { IoMdMail, IoLogoWhatsapp } from "react-icons/io"
import { PiMapPinFill } from "react-icons/pi"
import { useEffect, useState } from "react"
import useLang from "@/utlis/useLang"
import { useForm, usePage } from "@inertiajs/react"
import useFormChange from "@/utlis/useFormChange"
import BaseForm from "@/Components/Form/BaseForm"
import { IoSend } from "react-icons/io5"
import { useMediaQuery } from "react-responsive"

const Contact = (props) => {
  const smallDevices = (window.innerWidth >= 768 && window.innerWidth < 1024) || window.innerWidth < 768
  const bgPosition = smallDevices ? "center" : "center top -155px"

  return (
    <HomeLayout>
      <div className=" relative   ">
        {/* <div className="bg-gradient-to-l from-[#caebf8] to-transparent bg-[url('/image/texture/rectangle.webp')] bg-repeat " >  */}
        <div
          className="absolute inset-0 w-full h-60 md:h-[40vh] lg:bg-fixed lg:h-[70vh] 3xl:max-h-[920px] bg-[#0399DB] bg-cover bg-center bg-blend-multiply -z-0"
          style={{
            backgroundImage: "url('image/texture/rectangle.webp')",
            backgroundPosition: "center"
          }}
        ></div>

        <div className="flex flex-col items-center justify-center h-[30vh] lg:h-[50vh] 3xl:max-h-[720px]">
          <Hero />
        </div>

        <div className="flex flex-col items-center justify-center px-5 lg:px-0 text-black  relative  ">
          <Form info={props.footer} />
        </div>


      </div>
      <div className="bg-white lg:h-40"></div>

      <div className="flex flex-col items-center justify-center 0 h-[20vh] lg:h-[50vh] 3xl:max-h-[720px] mt-20">
        <Map content={props.addressMap} />
      </div>
    </HomeLayout>
  )
}

export default Contact

function Hero() {
  return (
    <>
      <div className="relative w-full h-screen  bg-blend-multiply  ">
        {/* Dark semi-transparent overlay */}
        {/* <div className="absolute inset-0 bg-[#0399DB] opacity-50"></div> */}
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse px-10 lg:px-40 pb-5 lg:pb-20 z-10 absolute">
          <FadeIn direction="vertical" duration={0.6} delay={0.2}>
            <h1 className="h1_hero text-white z-10 font-bold text-center ">{useLang("contact.hero.title")}</h1>
            <p className="p text-center">{useLang("contact.hero.tagline")}</p>
          </FadeIn>
        </div>

        {/* Your content */}
      </div>
    </>
  )
}

function Form({ info }) {
  const { props } = usePage()
  const [loaded, setLoaded] = useState(false)
  const [isSent, setIsSent] = useState(false)

  const { data, setData, post, errors, processing } = useForm({
    name: "",
    phone: "",
    email: "",
    company_name: "",
    category_id: "",
    capacity: "",
    project_name: "",
    location: ""
  })

  function handleChange(e) {
    const { name, value } = useFormChange(e, data)

    setData((state) => ({
      ...state,
      [name]: value
    }))
  }

  const handleSubmit = (e) => {
    e.preventDefault()
    post(`/contact`, {
      onSuccess: () => {
        setIsSent(true)
      }
    })
  }

  useEffect(() => {
    const timer = setTimeout(() => {
      setLoaded(true)
    }, 50) // small delay to trigger transition

    return () => clearTimeout(timer)
  }, [])

  const fontSizeStyle = `
  [&_p]:text-white
  [&_p]:p
`
  const baseFormProps = { data, errors, labelClassName: "text-black" }
  const isMobile = useMediaQuery({ maxWidth: 767 })

     const transitionClass = isMobile
    ? `${loaded ? "translate-y-0" : "translate-y-full"}`
    : `${loaded ? "translate-x-0" : "-translate-x-full"}`

     const transitionClassRev = isMobile
    ? `${loaded ? "translate-y-0" : "translate-y-full"}`
    : `${loaded ? "translate-x-0" : "-translate-x-[-100%]"}`



  return (
    <div className="w-full h-full  lg:px-40 ">
      <div className="md:gap-2  w-full flex md:flex-row flex-col-reverse">
        <div
          className={`bg-[#0399DB] transition-transform duration-700 ${transitionClass} md:w-1/3  lg:w-2/5 rounded-md lg:rounded-lg flex md:flex-col flex-wrap flex-row custom-shadow`}
        >
          <div className="flex-1 flex p-5 gap-5 flex-col flex-wrap lg:gap-5 lg:px-10 lg:py-12">
            <div className="w-full flex-1 text-white gap-2 lg:gap-4 flex items-center ">
              <PiMapPinFill className="text-4xl self-start" />
              <div>
                <p className="h3">{useLang("contact.form.office_label")}</p>

                <div className={`text-editor-content ${fontSizeStyle}`} dangerouslySetInnerHTML={{ __html: info.officeAddress }}></div>
              </div>
            </div>
            <div className="w-full flex-1  text-white gap-2 lg:gap-4 flex items-center ">
              <PiMapPinFill className="text-4xl self-start" />
              <div>
                <p className="h3">{useLang("contact.form.Warehouse_label")}</p>
                <div className={`text-editor-content ${fontSizeStyle}`} dangerouslySetInnerHTML={{ __html: info.warehouseAddress }}></div>
              </div>
            </div>
            <div className="w-full flex-1 text-white gap-2 lg:gap-4 flex items-center ">
              <FaPhone className="text-3xl" />
              <p className="h3">{info.phone}</p>
            </div>
            <div className="w-full flex-1 text-white gap-2 lg:gap-4 flex items-center ">
              <IoLogoWhatsapp className="text-3xl" />
              <p className="h3">{info.whatsapp}</p>
            </div>
            <div className="w-full flex-1 text-white gap-2 lg:gap-4 flex items-center ">
              <IoMdMail className="text-3xl" />
              <p className="h3">{info.email}</p>
            </div>
          </div>
          <div className="p-5 lg:p-0 lg:h-24  2xl:p-10 flex justify-center items-center ">
            {/* <h2 className="text-4xl font-bold text-white">GAMATECH</h2> */}
            <img src="/image/logos/Gamatech_vertical_white.png" alt="" className="lg:px-10 filter saturate-0 brightness-[500]" />
          </div>
        </div>

        {/* ================= */}

        {isSent ? (
          <div
            className={`bg-white text-base md:text-xl rounded-md lg:text-xl transition-transform duration-700 ${transitionClass} overflow-hidden  flex-1 lg:rounded-lg border-2 flex flex-col gap-2 lg:gap-1  custom-shadow p-5 `}
          >
            <div className="h-full flex flex-col gap-8 justify-center items-center">
              <i className="fas fa-circle-check text-green-600 fa-3x"></i>
              <p className="text-center text-green-500 font-bold">{useLang("contact.form.thanks_message")}</p>
            </div>
          </div>
        ) : (
          <form
            className={`bg-white p rounded-md transition-transform duration-700 ${transitionClassRev} overflow-hidden  flex-1 lg:rounded-lg border-2 flex flex-col gap-2 lg:gap-1  custom-shadow p-5 `}
          >
            <div className=" w-full flex-1 flex flex-col lg:p-1">
              <BaseForm label={useLang("contact.form.name_label")} name="name" {...baseFormProps}>
                <input
                  type="text"
                  name="name"
                  value={data?.name}
                  className="flex-1 border rounded-sm lg:rounded-md  lg:px-2"
                  onChange={handleChange}
                  placeholder={`${useLang("contact.form.name_placeholder")}`}
                ></input>
              </BaseForm>
            </div>

            <div className=" w-full flex-1 flex flex-col lg:flex-row gap-2 lg:gap-1 lg:p-1">
              <div className=" lg:w-2/5 flex flex-col">
                <BaseForm label={useLang("contact.form.number_label")} name="phone" {...baseFormProps}>
                  <input
                    type="tel"
                    name="phone"
                    value={data?.phone}
                    className="flex-1 border rounded-sm lg:rounded-md  lg:px-2"
                    onChange={handleChange}
                    placeholder={`${useLang("contact.form.number_placeholder")}`}
                  ></input>
                </BaseForm>
              </div>

              <div className="  flex-1 flex flex-col">
                <BaseForm label={useLang("contact.form.email_label")} name="email" {...baseFormProps}>
                  <input
                    type="email"
                    name="email"
                    value={data?.email}
                    className="flex-1 border rounded-sm lg:rounded-md  lg:px-2"
                    onChange={handleChange}
                    placeholder={`${useLang("contact.form.email_placeholder")}`}
                  ></input>
                </BaseForm>
              </div>
            </div>

            <div className=" w-full flex-1 flex flex-col lg:p-1">
              <BaseForm label={useLang("contact.form.company_label")} name="company_name" {...baseFormProps}>
                <input
                  type="text"
                  name="company_name"
                  value={data?.company_name}
                  className="flex-1 border rounded-sm lg:rounded-md  lg:px-2"
                  onChange={handleChange}
                  placeholder={`${useLang("contact.form.company_placeholder")}`}
                ></input>
              </BaseForm>
            </div>

            <div className=" w-full flex-1 flex flex-col lg:flex-row gap-2 lg:gap-1 lg:p-1">
              <div className=" w-full flex-1 flex flex-col">
                <BaseForm label={useLang("contact.form.requirement_label")} name="category_id" {...baseFormProps}>
                  <select
                    name="category_id"
                    value={data?.category_id}
                    onChange={handleChange}
                    className="flex-1 border rounded-sm lg:rounded-md lg:px-2"
                  >
                    <option value="">{useLang("contact.form.requirement_placeholder")}</option>
                    {props.categories.map((category, index) => (
                      <option key={index} value={category.id}>
                        {category.name}
                      </option>
                    ))}
                  </select>
                </BaseForm>
              </div>
              <div className=" w-full flex-1 flex flex-col">
                <BaseForm label={useLang("contact.form.capacity_label")} name="capacity" {...baseFormProps}>
                  <input
                    type="text"
                    name="capacity"
                    value={data?.capacity}
                    className="flex-1 border rounded-sm lg:rounded-md  lg:px-2"
                    onChange={handleChange}
                    placeholder={`${useLang("contact.form.capacity_placeholder")}`}
                  ></input>
                </BaseForm>
              </div>
            </div>

            <div className=" w-full flex-1 flex flex-col lg:p-1">
              <BaseForm label={useLang("contact.form.project_label")} name="project_name" {...baseFormProps}>
                <input
                  type="text"
                  name="project_name"
                  value={data?.project_name}
                  className="flex-1 border rounded-sm lg:rounded-md  lg:px-2"
                  onChange={handleChange}
                  placeholder={`${useLang("contact.form.project_placeholder")}`}
                ></input>
              </BaseForm>
            </div>

            <div className=" w-full h-32 lg:h-32   flex flex-col lg:p-1">
              <BaseForm label={useLang("contact.form.location_label")} name="location" {...baseFormProps}>
                <textarea
                  name="location"
                  value={data?.location}
                  className="flex-1 border rounded-sm lg:rounded-md lg:px-2 h-full "
                  onChange={handleChange}
                  placeholder={`${useLang("contact.form.location_placeholder")}`}
                ></textarea>
              </BaseForm>
            </div>
            <div className=" w-full flex-1 flex flex-row-reverse lg:p-1 items-center ">
              <button
                type="submit"
                onClick={handleSubmit}
                className="bg-[#0399DB] w-1/3 hover:bg-white border-2 border-[#0399DB] transition-all duration-300 relative overflow-hidden rounded-md flex justify-center items-center h-10 lg:h-12 cursor-pointer text-white font-bold group"
              >
                {/* Text 1 (initial) */}
                <span
                  className="
                  absolute w-full text-center transition-transform duration-300
                  transform -translate-x-full group-hover:translate-x-0
                "
                >
                  <IoSend className=" w-full lg:text-3xl text-[#0399DB]" />
                </span>

                {/* Text 2 (on hover) */}
                <span
                  className="
                  absolute w-full text-center transition-transform duration-300
                  transform -translate-x-0 group-hover:translate-x-full
                "
                >
                  {useLang("contact.form.send_button")}
                </span>
              </button>
            </div>
          </form>
        )}
      </div>
    </div>
  )
}

function Map({ content }) {
  const link = content[0].content

  return (
    <div className="h-full w-full">
      <iframe src={`${link}`} frameBorder="0" className="h-full w-full"></iframe>
    </div>
  )
}
