import HomeLayout from "@/Layouts/HomeLayout"
import useLang from "@/utlis/useLang"


import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"
import React from "react"
import { Accordion, AccordionHeader, AccordionBody } from "@material-tailwind/react"
import FadeIn from "../../../Components/animation/FadeIn"
import { IoIosArrowDown } from "react-icons/io"
import { RiFacebookCircleFill, RiInstagramFill, RiYoutubeFill } from "react-icons/ri"

import "./styles.css"

import "./styles.css"
import { usePage } from "@inertiajs/react"
import useButtonTitle from "@/utlis/useButtonTitle"
const Index = (props) => {
  const content = usePage().props
  const title = useButtonTitle()

  return (
    <HomeLayout>
      <div className=" relative to-transparent bg-[url('/image/texture/rectangle.webp')] bg-center bg-contain bg-opacity-20  bg-repeat  ">
        <div className="w-full h-full absolute bg-gradient-to-l from-[#ddf3fb] to-white  opacity-90"></div>
        <div className="flex flex-col items-center justify-center h-[20vh] lg:h-[50vh] max-h-[720px] ">
          <Hero />
        </div>

        <div className="flex flex-col items-center justify-center  relative ">
          <About content={content.profiles} title={title} />
        </div>
        <div className="flex flex-col items-center justify-center py-10 ">
          <VisionAndMission content={content.profiles} />
        </div>

        <div className="flex flex-col items-center justify-center py-10  ">
          <Market content={content.profiles} />
        </div>
      </div>
    </HomeLayout>
  )
}

export default Index

function Hero() {
  const smallDevices = (window.innerWidth >= 768 && window.innerWidth < 1024) || window.innerWidth < 768
  const bgPosition = smallDevices ? "center top -20px" : "center top -89px"

  return (
    <>
      <div
        className="relative w-full h-screen flex justify-center lg:bg-fixed bg-center bg-blend-luminosity bg-[#0399DB] "
        style={{
          backgroundImage: "url('/image/about/img-about.webp')",
          backgroundPosition: bgPosition,
          backgroundRepeat: "no-repeat",
          backgroundSize: "cover"
        }}
      >
        {/* Dark semi-transparent overlay */}
        <div className="absolute inset-0 bg-[#0399DB] opacity-50"></div>
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse max-w-screen-2xl px-10 lg:px-40 pb-5 lg:pb-20 z-10 absolute">
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <h1 className="h1_hero text-white z-10 ">{useLang("about.hero.title")}</h1>
          </FadeIn>
        </div>

        {/* Your content */}
      </div>
    </>
  )
}

function About({ content, title }) {
  const fontSizeStyle = `
  [&_p]:text-black
  [&_p]:p
  [&_p]:text-justify
`

  return (
    <div className="flex flex-col">
      <FadeIn direction="vetical" style={"h-full w-full"} duration={0.6} delay={0.2}>
        <div className=" flex  items-center justify-center  px-5 md:px-10 lg:px-20 pt-5 md:pt-10 lg:pt-20 w-full h-full  ">
          <div className="bg-gradient-to-tr relative justify-center from-[#0399DB] to-[#59BCE8] h-full w-full p-3 md:p-5  lg:py-20 flex lg:rounded-t-lg ">
            <div
              className="absolute  inset-0 top-0 bg-[#0399DB] bg-blend-luminosity "
              style={{
                backgroundImage: "url('/image/tech_texture.webp')",
                backgroundSize: "contain",
                // backgroundPosition: "center",
                opacity: 0.1,
                zIndex: 0
              }}
            />

            <FadeIn direction="vetical" style={"h-full w-full"} duration={0.6} delay={0.4}>
              <div className="flex-1 flex flex-col max-w-screen-2xl  lg:px-20 items-end lg:items-center md:flex-row   lg:space-y-10 leading-tight ">
                <div className="md:flex-1 flex flex-col gap-1 md:gap-2 lg:gap-4">
                  <h2 className="h2">{content.companyName[0].content}</h2>
                  <p className="p">{content.tagline[0].content}</p>
                </div>

                <div className=" flex   items-center gap-1 z-40 lg:gap-2  ">
                  <a
                    title={`${title}`}
                    href={`${content.instagram[0].content}`}
                    className="hover:text-[#064D6C] cursor-pointer hover:scale-110 transition-all duration-300 "
                  >
                    <RiInstagramFill className="text-xl md:text-3xl lg:text-6xl" />
                  </a>
                  <a
                    title={`${title}`}
                    href={`${content.facebook[0].content}`}
                    className="hover:text-[#064D6C] cursor-pointer hover:scale-110 transition-all duration-300 "
                  >
                    <RiFacebookCircleFill className="text-xl md:text-3xl lg:text-6xl" />
                  </a>
                  <a
                    title={`${title}`}
                    href={`${content.youtube[0].content}`}
                    className="hover:text-[#064D6C] cursor-pointer hover:scale-110 transition-all duration-300 "
                  >
                    <RiYoutubeFill className="text-2xl md:text-4xl lg:text-7xl" />
                  </a>
                </div>
              </div>
            </FadeIn>
          </div>
        </div>
      </FadeIn>

      <div className=" z-10 w-full h-full flex  flex-col-reverse">
        <div className=" w-full bg-white justify-center items-center custom-shadow-strong flex flex-col md:flex-row md:justify-center px-5 md:px-10 lg:p-0 lg:py-5">
          <div className=" flex  h-full   justify-center items-end min-w-[40%] max-w-screen-2xl ">
            <FadeIn reverse={true} direction="horizontal" style={"h-full w-full flex justify-center items-center "} duration={0.6} delay={0.2}>
              <img src="/image/logos/Gamatech_square.webp" alt="" className="w-full max-w-[16rem]" />
            </FadeIn>
          </div>

          <div className="flex-1 h-full  text-black flex flex-col justify-center max-w-screen-2xl   lg:gap-20 ">
            <FadeIn direction="horizontal" style={"h-full w-full"} duration={0.6} delay={0.2}>
              <div className="flex-1 h-full text-black flex flex-col justify-center gap-1 md:gap-4  lg:px-20  ">
                <h2 className="lg:text-3xl text-base md:text-2xl font-bold text-[#0399DB]">{useLang("about.about.title")}</h2>
                <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: content.about[0].content }}></div>

                <div className="flex py-3 lg:py-0 gap-5 lg:gap-20">
                  <p className="lg:text-xl text-base md:text-base">
                    {useLang("about.about.since")} <br /> <span className="text-[#0399DB]">{content.foundedYear[0].content}</span>
                  </p>
                  <p className="lg:text-xl text-base md:text-base ">
                    {useLang("about.about.location")} <br /> <span className="text-[#0399DB]">{content.location[0].content}</span>
                  </p>
                </div>
              </div>
            </FadeIn>
          </div>
        </div>
      </div>

      <div className=" flex  items-center justify-center  px-5 md:px-10 lg:px-20  w-full h-full  ">
        <div className="bg-gradient-to-tr relative justify-center from-[#0399DB] to-[#59BCE8] h-full w-full p-3 md:p-5  lg:py-20 flex lg:rounded-b-lg ">
          <div
            className="absolute  inset-0 top-0 bg-[#0399DB] bg-blend-luminosity "
            style={{
              backgroundImage: "url('/image/tech_texture.webp')",
              backgroundSize: "contain",
              // backgroundPosition: "center",
              opacity: 0.1,
              zIndex: 0
            }}
          />
        </div>
      </div>
    </div>
  )
}

function VisionAndMission({ content }) {
  const data = [
    {
      title: useLang("about.visionAndMission.mision_title"),
      description: content.vision[0].content
    },
    {
      title: useLang("about.visionAndMission.mission_title"),
      description: content.mission[0].content
    }
  ]

  return (
    <>
      <div className=" h-full max-w-screen-2xl w-full pl-5 md:pl-10 lg:pl-40 flex  ">
        <div className="flex-1 flex flex-col my-auto text-black">
          <FadeIn reverse={true} direction="horizontal" style={"h-full w-full flex flex-col justify-center items-center "} duration={0.6} delay={0.2}>
            <AccordionCustomStyles content={data} />
          </FadeIn>
        </div>

        <div className="w-1/3   overflow-hidden opacity-40  mt-auto  lg:pt-10 lg:pl-20">
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <img src="\image\texture\target.webp" alt="terget" />
          </FadeIn>
        </div>
      </div>
    </>
  )
}

export function AccordionCustomStyles({ content }) {
  const [open, setOpen] = React.useState(0)

  const handleOpen = (value) => setOpen(open === value ? -1 : value)

  const fontSizeStyle = `
  [&_p]:text-black
  [&_]:p
  [&_p]:text-justify
`

  return (
    <>
      {content.map((el, index) => (
        <Accordion key={index} open={open === index} className="lg:mb-2 border-b lg:border-b-2 border-black lg:px-4 text-black">
          <AccordionHeader
            onClick={() => handleOpen(index)}
            className={`flex items-center  justify-between border-b-0 py-[5px] transition-colors h3${open === index ? "text-[#0399DB]" : ""}`}
          >
            <div className="flex-1 h3">{el.title}</div>

            <IoIosArrowDown
              className={`lg:h-6 lg:w-6  transform transition-transform duration-300 ${open === index ? "rotate-180 text-[#0399DB]" : ""}`}
            />
          </AccordionHeader>

          <AccordionBody className="pt-0 font-normal py-[-10px] p lg:py-5 p">
            <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: el.description }}></div>
          </AccordionBody>
        </Accordion>
      ))}
    </>
  )
}

function Market({ content }) {
  const fontSizeStyle = `
  [&_p]:text-black
  [&_p]:p
  [&_p]:text-justify
`

  const data = content.marketSegmentList?.map((marketSegment) => ({
    title: marketSegment.label,
    description: marketSegment.content
  }))

  return (
    <FadeIn reverse={true} direction="horizontal" style={"h-full w-full flex flex-col justify-center items-center "} duration={0.6} delay={0.3}>
      <div className="z-10 h-full w-full p-5  bg-white  ">
        <FadeIn
          direction="horizontal"
          style={
            "h-full w-full flex flex-col justify-center items-center flex flex-col items-center md:p-10 lg:px-20 gap-2 md:gap-5 max-w-[1200px] mx-auto lg:gap-10 "
          }
          duration={0.6}
          delay={0.5}
        >
          <h2 className="h1 text-black">{useLang("about.market.title")}</h2>

          <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: content.marketSegment[0].content }}></div>

          <div className="w-full">
            <AccordionCustomStyles content={data} />
          </div>
        </FadeIn>
      </div>
    </FadeIn>
  )
}
