import HomeLayout from "@/Layouts/HomeLayout"

import "./styles.css"
import { GoGear } from "react-icons/go"
import { VscTools } from "react-icons/vsc"
import { RiCustomerServiceLine } from "react-icons/ri"
import { FaGears } from "react-icons/fa6"
import FadeIn from "@/Components/animation/FadeIn"
import useLang from "@/utlis/useLang"
import useButtonTitle from "@/utlis/useButtonTitle"
import { useMediaQuery } from "react-responsive"

const Index = (props) => {
  const title = useButtonTitle()

  return (
    <HomeLayout>
      <div className="flex flex-col items-center justify-center h-[20vh] lg:h-[50vh] max-h-[720px]">
        <Hero />
      </div>

      <div className=" flex flex-col items-center justify-center  relative text-black  shadow-lg ">
        <Service content={props.afterSales} />
      </div>
      <div className="lg:h-20"></div>
      <div className=" flex flex-col items-center justify-center  relative ">
        <ServiceCTA title={title} email={props.footer.email}/>
      </div>

      <div className=" flex flex-col items-center justify-center   relative ">
        <Requirement content={props.requirementAfterSales} />
      </div>


    </HomeLayout>
  )
}

export default Index

function Hero() {
  const smallDevices = (window.innerWidth >= 768 && window.innerWidth < 1024) || window.innerWidth < 768
  const bgPosition = smallDevices ? "center top -80px" : "center bottom 255px"

  return (
    <>
      <div className="relative flex justify-center w-full h-screen bg-cover bg-center bg-blend-luminosity bg-[#0399DB]">
        <div
          className="absolute  inset-0 bg-cover lg:bg-fixed bg-center bg-no-repeat opacity-40"
          style={{
            backgroundImage: "url('/image/bg/worker_service.webp')",
            // backgroundPosition: bgPosition
          }}
        ></div>

        {/* Dark semi-transparent overlay */}
        <div className="absolute inset-0 bg-[#0399DB] opacity-50"></div>
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse max-w-screen-2xl px-10 lg:px-40 pb-5 lg:pb-20 z-10 absolute">
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <h1 className="h1_hero text-white z-10 font-bold ">{useLang("afterSales.Hero.title")}</h1>
          </FadeIn>
        </div>

        {/* Your content */}
      </div>
    </>
  )
}

function Service({ content }) {
  const fontSizeStyle = `
  [&_p]:text-black
  [&_p]:p
  [&_p]:pt-5
  [&_ul]:p
`
  const isMobile = useMediaQuery({ maxWidth: 767 })

  return (
    <>


    {/* ======== error here ============= */}

    
      <div className="h-full w-full absolute  ">{/* import tech  */}</div>
      <FadeIn direction={isMobile ? 'vertical' : 'horizontal'} duration={0.6} delay={0.2}>
        <div className="h-full w-full max-w-screen-2xl  md:pb-5 bg-contain bg-no-repeat bg-pink   md:bg-none lg:bg-[url('/image/bg/worker.webp')] p-10 lg:px-40 lg:py-20 z-10 bg-bottom lg:bg-right">
          <FadeIn direction={isMobile ? 'vertical' : 'horizontal'} duration={0.6} delay={0.3}>
            <div className=" h-full w-full flex flex-col lg:flex-row gap-5">
              {content.map((item, index) => (
                <div key={index} className=" h-full flex-1 flex flex-col gap-3 justify-between  ">
                  <div className="flex items-center gap-5 lg:min-h-36">
                    <img src={`${item.thumbnail}`} alt="" className="h-20" />
                    <h2 className="h1 text-[#0399DB]">{item.name}</h2>
                  </div>
                  <div>
                    <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: item.description }}></div>
                  </div>
                </div>
              ))}

              <div className="hidden   lg:flex flex-1"></div>
            </div>
          </FadeIn>
        </div>
      </FadeIn>
    </>
  )
}

function ServiceCTA({title ,email}) {
  return (
    <div className="bg-gradient-to-r relative overflow-hidden  py-10  md:py-12 lg:py-20 from-[#025275] to-[#0399DB] h-full w-full flex flex-col justify-center items-center text-center gap-5 lg:gap-10">
      <div
        className="absolute top-0 bg-[#0399DB] w-full h-full bg-cover bg-center flex flex-row justify-center items-center opacity-85 bg-blend-multiply"
        style={{ backgroundImage: "url('/image/tech_texture.webp')" }}
      ></div>
      <div className="absolute top-0 bg-gradient-to-r from-[#025275] to-[#0399DB] w-full h-full opacity-85"></div>

      <div className="h-full w-full absolute z-10 ">
        <FadeIn direction="vertical" style={"h-full w-full"}>
          <GoGear className="text-[200pt] md:text-[300pt] lg:text-[400pt] absolute right-[200px] md:left-[-150px] bottom-[-150px] text-[#80A9BB]" />
        </FadeIn>
        <FaGears className="text-5xl md:text-8xl lg:text-9xl absolute right-5 lg:right-40 top-2 lg:top-10 text-[#B9DBEA]" />
      </div>

      <div className="h1 text-white z-10">
        <h2>
          {useLang("afterSales.CTA.title")}
          <br />
          {useLang("afterSales.CTA.title_nextLine")}
        </h2>
      </div>
      <div className="z-10">
        <a title={`${title}`} href={`mailto:${email}`} className="text-[#0399DB] cursor-pointer flex gap-1 lg:gap-2 h3   rounded-md shadow-xl   bg-white hover:text-white hover:scale-105 transition-all  hover:bg-[#0399DB] p-2 lg:p-3 lg:rounded-md  duration-300">
          <RiCustomerServiceLine className="text-xl lg:text-2xl " />
          {useLang("afterSales.CTA.contact_button")}
        </a>
      </div>
    </div>
  )
}

function Requirement({ content }) {
  const fontSizeStyle = `
  [&_ol]:pl-4
  [&_ol]:mt-0
  [&_ol]:text-black
  [&_ol]:p
  [&_li]:lg:pt-1
`

  return (
    <div className="h-full w-full max-w-screen-2xl p-5 lg:py-20 text-black lg:px-40">
      <div className="text-sm md:text-base lg:text-lg mb-1 font-semibold">
        <h2>{useLang("afterSales.Requirement.title")}</h2>
      </div>

      <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: content.content }}></div>
    </div>
  )
}
