import HomeLayout from "@/Layouts/HomeLayout"

import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"
import React, { useState } from "react"

import "../Home/styles.css"
import CTA from "@/Components/CTA"
import useLang from "@/utlis/useLang"
import FadeIn from "@/Components/animation/FadeIn"
import { date } from "@/utlis/format"
import { Accordion, AccordionBody, AccordionHeader } from "@material-tailwind/react"
import { IoIosArrowDown } from "react-icons/io"
import useButtonTitle from "@/utlis/useButtonTitle"

const Index = (props) => {
  const title =useButtonTitle()
  return (
    <HomeLayout>
      <div className="bg-gradient-to-bl relative from-[#daf0fa] to-transparent">
        <div
          className="absolute inset-0 w-full h-[25vh] md:h-[25vh] lg:h-[70vh] bg-[#0399DB]  bg-cover bg-center bg-blend-luminosity -z-0 max-h-[920px]"
          style={{
            backgroundImage: "url('image/bg/career-hero.webp')",
            backgroundPosition: "top"
          }}
        >
          <div className="z-10 h-full  w-full bg-[#0399DB] opacity-60"></div>
        </div>

        <div className="flex flex-col items-center justify-center h-[20vh] lg:h-[50vh] max-h-[720px]">
          <Hero />
        </div>

        <div className="relative px-5 lg:px-40 flex flex-col items-center justify-center mb-10 lg:min-h-screen 3xl:min-h-full ">
          <Jobs content={props.careers} title={title} />
        </div>

        <div className="flex flex-col items-center justify-center">
          <CTA />
        </div>

      </div>
    </HomeLayout>
  )
}

export default Index

function Hero() {
  return (
    <>
      <div
        className="relative w-full h-screen flex justify-center bg-cover bg-center bg-blend-luminosity  "
        style={{
          backgroundImage: "url()",
          backgroundPosition: "center top -89px"
        }}
      >
        {/* Dark semi-transparent overlay */}

        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse max-w-screen-2xl px-10 lg:px-40 pb-5 lg:pb-20 z-10 absolute">
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <h1 className="h1_hero text-white z-10   ">{useLang("career.hero.label")}</h1>
          </FadeIn>
        </div>

        {/* Your content */}
      </div>
    </>
  )
}

function Jobs({ content ,title}) {
  return (
    <div className=" text-black">
      <div className="flex flex-col lg:py-10 flex-1 py-2  w-full gap-1 lg:gap-5   ">
        {content.map((item, index) => (
          <div key={index} className="bg-white flex-1 w-full lg:min-h-56   custom-shadow-strong rounded-md lg:rounded-md flex flex-col gap-5 lg:flex-row  p-2 lg:p-5">
            <div className="flex-1   ">
              <div className="h3">{item.title}</div>
              <div>
                <p className="p mt-2">{useLang("career.job.description_label")}</p>

                <p className="p my-2">{item.description}</p>

                <AccordionCustomStyles content={item.qualification} />
              </div>
            </div>

            <div className="lg:w-1/5 p-1 lg:p-4 flex lg:flex-col justify-between items-center text-xs  md:p">
              <div className="flex gap-5 lg:flex-col  w-full">
                <div>
                <p className="text-left font-semibold">{useLang("career.job.posted")}</p>
                <p className=" text-left">{date(item.published_at)}</p>
                </div>
                  <div>
                <p className="text-left font-semibold">{useLang("career.job.Location")}</p>
                <p className=" text-left">{item.location}</p>

                  </div>
              </div>

                <a title={`${title}`} href={`mailto:${item.email}`} className="whitespace-pre px-2 bg-[#0399DB] h3 text-sm text-white text-center rounded-sm  border-2 border-[#0399DB] hover:bg-white hover:text-[#0399DB] transition-all duration-300">
                  {useLang("career.job.apply_button")}
                </a>

            </div>
          </div>
        ))}
      </div>
    </div>
  )
}

export function AccordionCustomStyles({ content }) {
  const [open, setOpen] = React.useState(false)

  const handleOpen = () => setOpen(!open)
  const fontSizeStyle = `
  [&_p]:text-black
  [&_ol]:p
  [&_p]:text-justify
`
  return (
    <Accordion open={open} className="lg:mb-2 border-b w-full lg:border-b border-black  text-black">
      <AccordionHeader
        onClick={handleOpen}
        className={`flex items-center justify-between border-b-0 py-[5px] w-full transition-colors p ${
          open ? "text-[#0399DB]" : ""
        }`}
      >
        <div className="flex-1">
          <p className="h3">{useLang("career.job.qualification")}</p>
        </div>

        <div className="">
          <IoIosArrowDown className={`lg:h-6 lg:w-6  transform transition-transform duration-300 ${open ? "rotate-180 text-[#0399DB]" : ""}`} />
        </div>
      </AccordionHeader>

      <AccordionBody className="pt-0   lg:py-5 ">
        <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: content }}></div>
      </AccordionBody>
    </Accordion>
  )
}
