import HomeLayout from "@/Layouts/HomeLayout"

import { GoGear } from "react-icons/go"
import { VscTools } from "react-icons/vsc"
import { RiCustomerServiceLine } from "react-icons/ri"
import { FaGears } from "react-icons/fa6"
import useLang from "@/utlis/useLang"
import CTA from "@/Components/CTA"
import FadeIn from "@/Components/animation/FadeIn"
import "./styles.css"
import { useState } from "react"
import { IoIosArrowBack, IoIosArrowForward } from "react-icons/io"

const Gallery = (props) => {
  return (
    <HomeLayout>
      <div className="bg-gradient-to-l from-[#daf0fa] to-transparent h-full w-full">
        <div className="flex flex-col items-center justify-center h-[20vh] lg:h-[50vh] max-h-[720px]">
          <Hero />
        </div>

        <div className="flex justify-center items-center p-5  w-full text-black lg:py-20 lg:px-40">
          <FadeIn direction="vertical" duration={0.6} delay={0.2}>
            <div className="p text-justify">{useLang("gallery.tagline.tagline")}</div>
          </FadeIn>
        </div>

        <div className=" flex flex-col items-center justify-center relative ">
          <Photo content={props.galleries} />
        </div>

        <div className="flex items-center justify-center h-20 lg:h-[20vh]  lg:px-40"></div>
        <div className="flex flex-col items-center justify-center">
          <CTA />
        </div>
      </div>
    </HomeLayout>
  )
}

export default Gallery

function Hero() {
  const smallDevices = (window.innerWidth >= 768 && window.innerWidth < 1024) || window.innerWidth < 768
  const bgPosition = smallDevices ? "center" : "center top -155px"

  return (
    <>
      <div
        className="relative w-full flex justify-center h-full bg-cover lg:bg-fixed bg-center  bg-[#0399DB] bg-blend-luminosity "
        style={{
          backgroundImage: "url('image/bg/City-line.png')",
          backgroundPosition: bgPosition
        }}
      >
        {/* Dark semi-transparent overlay */}
        <div className="absolute inset-0 bg-[#0399DB] opacity-50"></div>
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse max-w-screen-2xl px-10 lg:px-40 pb-5 lg:pb-20 z-10 absolute">
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <h1 className="h1_hero text-white z-10 ">{useLang("gallery.hero.title")}</h1>
          </FadeIn>
        </div>

        {/* Your content */}
      </div>
    </>
  )
}

function Photo({ content }) {
  const [isOpen, setIsOpen] = useState(false)
  const [currentIndex, setCurrentIndex] = useState(0)

  const handleOpen = (index) => {
    setCurrentIndex(index)
    setIsOpen(true)
  }

  const handleNext = () => {
    setCurrentIndex((prevIndex) => (prevIndex + 1) % content.length)
  }

  const handlePrev = () => {
    setCurrentIndex((prevIndex) => (prevIndex - 1 + content.length) % content.length)
  }

  const currentImage = content[currentIndex]?.image || ""
  const currentDescription = content[currentIndex]?.description || ""

  return (
    <div className="w-full h-full px-5 lg:px-40 ">
      <div className="grid grid-cols-2 sm:grid-cols-2 lg:grid-cols-3 gap-1 w-full h-full">
        {content.map((item, index) => (
          <FadeIn style="w-full" delay={(index % 3) * 0.1} key={index}>
            <div className="relative aspect-square w-full overflow-hidden group">
              {/* Visible content */}
              <div className="flex items-center justify-center h-full text-white text-xl font-bold">
                <img src={item.image} alt="" className="w-full h-full object-cover aspect-square" />
              </div>

              {/* Hidden description (shows on hover) */}
              <button
                onClick={() => handleOpen(index)}
                className="hidden cursor-pointer absolute inset-0 bg-black/70 text-white lg:flex lg:flex-col items-center backdrop-blur-sm justify-center opacity-0 group-hover:opacity-100 transition-opacity duration-300"
              >
                <p className="text-center px-2">{item.description}</p>
                <p className="text-center md:text-base md:p-2 px-4 md:font-semibold rounded-sm">{useLang("gallery.Photo.detail_button")}</p>
              </button>

              <button onClick={() => handleOpen(index)} className="lg:hidden absolute inset-0 text-white flex justify-center">
                <p className="text-center md:text-base backdrop-blur-sm bg-black/70 w-full self-end md:p-2 px-4 md:font-semibold rounded-sm">
                  {useLang("gallery.Photo.detail_button")}
                </p>
              </button>
            </div>
          </FadeIn>
        ))}

        {/* Modal */}
        {isOpen && (
          <div className="fixed inset-0 transition-all duration-300 bg-black p-2 lg:p-5 lg:px-32 lg:gap-5 lg:py-28 bg-opacity-80 flex flex-col items-center justify-center z-50">
            <FadeIn delay={0.3} style={"w-full"}>
              <div className="w-full h-fit flex flex-row-reverse  rounded-lg ">
                <button onClick={() => setIsOpen(false)} className="mt-2 px-4 py-2 bg-[#E53134] self-start h3 text-white rounded hover:bg-red-700">
                  {useLang("gallery.Photo.close_button")}
                </button>
              </div>
            </FadeIn>

            <FadeIn style={"h-fit lg:h-full w-full flex flex items-center py-5 md:p-5  lg:p-0 justify-center"}>
              <button onClick={handlePrev} className="prev-her hover:cursor-pointer hover:scale-110 transition-all duration-300 cursor-pointer">
                <IoIosArrowBack className="text-4xl lg:text-7xl" />
              </button>

              <div className="w-full flex flex-col items-center rounded-lg lg:h-full">
                <img src={currentImage} alt="" className="h-full " />
                <div className="">
                  <p className="text-center p px-2 mt-2">{currentDescription}</p>
                </div>
              </div>

              <button onClick={handleNext} className="next-hero hover:cursor-pointer hover:scale-110 transition-all duration-300 cursor-pointer">
                <IoIosArrowForward className="text-4xl lg:text-7xl" />
              </button>
            </FadeIn>
          </div>
        )}
      </div>
    </div>
  )
}
