import HomeLayout from "@/Layouts/HomeLayout"
import useLang from "@/utlis/useLang"
import { Swiper, SwiperSlide } from "swiper/react"
import FadeIn from "@/Components/animation/FadeIn"
import CountUp from "@/Components/animation/CountUp"
import { sharedSlideAtom, updateSlideAtom } from "@/atoms"
import { useEffect, useRef, useState } from "react"
import { useAtom } from "jotai"

import { GoArrowRight } from "react-icons/go"

import { RiFacebookCircleFill, RiInstagramFill, RiYoutubeFill } from "react-icons/ri"
import { IoIosArrowForward, IoIosArrowBack } from "react-icons/io"

import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"

import { Autoplay, Pagination, Navigation, EffectCoverflow } from "swiper/modules"

import "./styles.css"
import { usePage } from "@inertiajs/react"
import { date } from "@/utlis/format"

import CTA from "@/Components/CTA"

import useButtonTitle from "@/utlis/useButtonTitle"

function useMediaQuery(query) {
  const [matches, setMatches] = useState(false)

  useEffect(() => {
    const media = window.matchMedia(query)
    const handler = () => setMatches(media.matches)

    handler()
    media.addEventListener("change", handler)
    return () => media.removeEventListener("change", handler)
  }, [query])

  return matches
}

const Index = (props) => {
  const content = usePage().props
  const title = useButtonTitle()

  return (
    <HomeLayout>
      <div className="flex  flex-col items-center justify-center h-[50vh]  md:min-h-[45vh] lg:h-screen 3xl:min-h-full max-h-[960px]">
        <Hero title={title} />
      </div>

      <div className="flex flex-col items-center justify-center 3xl:max-h-[720px]  mt-2 max-h-fit">
        <About content={content} link={{ ig: content.footer.instagram, fac: content.footer.facebook, you: content.footer.youtube }} />
      </div>
      <div className="flex flex-col items-center justify-center  sm:min-h-[30vh] lg:h-[60vh] 3xl:max-h-[720px] ">
        <Unique content={content.uniquePoints} />
      </div>

      <div className="flex flex-col items-center  justify-center  ">
        <FeaturedProduct title={title} content={content.categories} />
      </div>
      <div className="flex flex-col items-center justify-center  lg:h-[60vh] 3xl:max-h-[520px] shadow-lg">
        <SellingPoint content={content.clients} />
      </div>
      <div className="flex flex-col items-center justify-center md:my-5">
        <Testimonial content={content.testimonies} />
      </div>

      <div className="flex flex-col items-center justify-center relative">
        <div
          className="absolute inset-0  bg-cover bg-center bg-no-repeat grayscale bg-fixed"
          style={{
            backgroundImage: "url('/image/bg/bg-artikel.jpg')"
          }}
        ></div>

        {/* Gradient overlay */}
        <div className="absolute inset-0  bg-gradient-to-t from-[#0399DB]/80 to-transparent"></div>

        <Article title={title} content={content.articles} />
      </div>

      <div title={title} className="flex flex-col items-center justify-center  ">
        <CTA />
      </div>
    </HomeLayout>
  )
}

export default Index

function Hero({ title }) {
  const { props } = usePage()
  const isMobile = useMediaQuery("(max-width: 768px)")

  const swiperRef = useRef(null)
  const videoRef = useRef(null)

  const [delay, setDelay] = useState(4000)

  const handleSlideChange = (swiper) => {
    const currentSlideIndex = swiper.activeIndex

    // Example: Restart video only on a specific slide (e.g., index 0)
    if (currentSlideIndex === 0 && videoRef.current) {
      setDelay(3700)
      videoRef.current.currentTime = 0
      videoRef.current.play()
    } else {
      setDelay(5000)
    }
  }

  let banners = props.banners

  return (
    <>
      <Swiper
        onSlideChange={handleSlideChange}
        ref={swiperRef}
        spaceBetween={0}
        slidesPerView={1}
        navigation={!isMobile}
        autoplay={{
          delay: delay,
          disableOnInteraction: false
        }}
        centeredSlides={true}
        modules={[Autoplay, Pagination, Navigation]}
        className="h-full"
      >
        {banners.map((banner, index) =>
          banner.type === "video" ? (
            <SwiperSlide key={index}>
              <div className="w-full h-full bg-cover md:bg-center flex flex-row justify-center items-center max-w-screen-3xl bg-left ">
                <div className="absolute z-10 w-full h-full overflow-hidden">
                  <video
                    ref={videoRef}
                    loop
                    autoPlay
                    muted
                    playsInline
                    className="absolute top-0 left-0 w-full h-full object-cover z-[-1] transition-opacity duration-1000"
                  >
                    {banner.file === "/assets/video/video-720p.mp4" ? (
                      <>
                        <source src="/assets/video/video-480p.mp4" media="(max-width: 600px)" type="video/mp4" />
                        <source src="/assets/video/video-720p.mp4" media="(max-width: 1024px)" type="video/mp4" />
                        <source src="/assets/video/video-1080p.mp4" media="(max-width: 1920px)" type="video/mp4" />
                        <source src="/assets/video/video-2160p.mp4" type="video/mp4" />
                      </>
                    ) : (
                      <source src={banner.file} type="video/mp4" />
                    )}
                    Your browser does not support the video tag.
                  </video>
                  <div className="flex items-center justify-center h-full bg-gradient-to-b from-black to-transparent opacity-80 text-white z-10"></div>
                </div>
              </div>
            </SwiperSlide>
          ) : (
            <SwiperSlide key={index}>
              <div className="w-full h-full bg-cover md:bg-center flex relative flex-row justify-center items-center max-w-screen-3xl bg-left ">
                <div
                  className={`flex items-center justify-center w-full absolute h-full ${banner.title === "" && "hidden"} bg-gradient-to-b from-black to-transparent opacity-80 text-white z-10`}
                ></div>
                <img src={banner.file} alt={banner.alt || "hero"} className="absolute w-full h-full bg-right" />
                <div className="z-10 h-full flex-1 min-w-screen flex flex-col items-start justify-center gap-5 lg:gap-10 p-5 py-12 sm:p-20 lg:p-40 lg:px-20 2xl:p-40">
                  <>
                    {banner.title && (
                      <FadeIn direction="up" duration={0.6} delay={4.5} style={" lg:w-1/2"}>
                        <div
                          className="[&_p]:h1 [&_p]:text-left [&_p]:leading-tight [&_b]:bg-[#E53134] [&_b]:rounded-md  [&_b]:px-1 [&_b]:lg:px-4 [&_b]:mx-1"
                          dangerouslySetInnerHTML={{ __html: banner.title }}
                        ></div>
                      </FadeIn>
                    )}

                    {banner.description && (
                      <FadeIn direction="up" duration={0.6} delay={4.7} style={" lg:w-1/2"}>
                        <div className="[&_p]:p  [&_p]:text-left [&_p]:leading-tight" dangerouslySetInnerHTML={{ __html: banner.description }}></div>
                      </FadeIn>
                    )}

                    {banner.is_action_button !== 0 && (
                      <FadeIn direction="up" style={"w-fit lg:w-full lg:w-1/2"} duration={0.6} delay={4.9}>
                        <a
                          href={banner.action_url || "#"}
                          title={`${title}`}
                          className="group bg-white p-1 sm:px-1 sm:py-1 rounded-full flex items-center justify-between lg:w-fit max-w-sm shadow-md text-[#0399DB] hover:scale-105 hover:bg-[#0399DB] transition-all duration-200"
                        >
                          <span className="h3 px-1 lg:px-4 flex-1 group-hover:text-white transition-colors duration-200">
                            {useLang("home.hero.see_Product_btn")}
                          </span>
                          <div className="bg-[#0399DB] h-6 aspect-square sm:h-6 sm:w-6 lg:h-12 lg:w-12 rounded-full flex items-center justify-center text-white group-hover:bg-white group-hover:text-[#0399DB] transition-colors duration-200">
                            <GoArrowRight className="w-4 h-4 sm:w-6 sm:h-6" />
                          </div>
                        </a>
                      </FadeIn>
                    )}
                  </>
                </div>
              </div>
            </SwiperSlide>
          )
        )}

        {/* ========================================================================= */}

        <div className="hidden lg:block">
          <div className="prev-hero absolute left-0 -translate-x-full top-1/2  -translate-y-1/2 z-10 cursor-pointer  ">
            <IoIosArrowBack className="lg:text-7xl" />
          </div>
          <div className="next-hero absolute right-0 translate-x-full top-1/2 -translate-y-1/2 z-10 cursor-pointer  ">
            <IoIosArrowForward className="lg:text-7xl" />
          </div>
        </div>
      </Swiper>
    </>
  )
}

function About({ content, link, title }) {
  const { props } = usePage()

  const fontSizeStyle_p = `
  [&_p]:p
  [&_p]:text-justify
  [&_p]:sm:pt-5
  [&_p]:leading-relaxed
`

  return (
    <div className="h-full w-full relative  ">
      <div className="w-full h-full px-3 md:px-20 lg:px-0 md:py-5 lg:py-0 lg:min-h-[65vh] 2xl:min-h-full 2xl:max-h-[720px]  flex justify-center items-center bg-gradient-to-bl from-[#0C6A93] to-[#0399DB] text-white relative overflow-hidden">
        {/* Background Texture */}
        <div
          className="absolute inset-0 bg-blend-screen"
          style={{
            backgroundImage: "url('image/texture/tech-black.webp')",
            backgroundSize: "cover",
            backgroundPosition: "center",
            opacity: 0.16,
            zIndex: 0
          }}
        />

        <div className="absolute bottom-0 left-0 w-full h-full curve-line flex"></div>
        <div className="absolute bottom-0 left-0 w-full h-full curve-line-border flex "></div>

        {/* Content Wrapper */}
        <div className="relative h-full lg:min-h-[65vh] 2xl:min-h-full w-full 3xl:max-h-[720px] z-10 flex items-center justify-center lg:justify-between  px-4 lg:pl-20 lg:px-0  2xl:pl-40 ">
          {/* Left Section */}

          <div className="flex-1 lg:w-1/2 flex flex-col  py-5  lg:gap-10  justify-center ">
            <FadeIn direction="up" style={"h-full w-full flex md:gap-0 flex-col gap-5 "} duration={0.6} delay={0.2}>
              <div className="flex flex-col lg:gap-2  overflow-visible ">
                <h1 className="h1 text-center lg:text-left ">{content.companyName}</h1>

                <p className="h3 tracking-widest text-center lg:text-left ">{useLang("home.about.tagline")}</p>
              </div>

              <div className="lg:hidden m-1 h-40 md:h-72  rounded-md overflow-hidden flex justify-center items-center">
                <img src={props.aboutImage} alt="" className="w-full md:hidde object-cover bg-center" />
              </div>

              <div className={`text-editor-content ${fontSizeStyle_p} `} dangerouslySetInnerHTML={{ __html: content.about }}></div>
              {/* Social Icons */}
              <div className="flex items-center gap-1 lg:gap-2 pt-2 lg:pt-5 2xl:pt-10">
                <a
                  target="_blank"
                  href={`${link.ig}`}
                  title={`${title}`}
                  className="hover:text-[#064D6C] cursor-pointer hover:scale-110 transition-all duration-300 "
                >
                  <RiInstagramFill className="text-2xl md:text-4xl lg:text-5xl" />
                </a>
                <a
                  title={`${title}`}
                  target="_blank"
                  href={`${link.fac}`}
                  className="hover:text-[#064D6C] cursor-pointer hover:scale-110 transition-all duration-300 "
                >
                  <RiFacebookCircleFill className="text-2xl md:text-4xl lg:text-5xl scale-105" />
                </a>
                <a
                  title={`${title}`}
                  target="_blank"
                  href={`${link.you}`}
                  className="hover:text-[#064D6C] cursor-pointer hover:scale-110 transition-all duration-300 "
                >
                  <RiYoutubeFill className="text-2xl scale-105 lg:scale-100 md:text-4xl lg:text-6xl" />
                </a>
              </div>
            </FadeIn>
          </div>

          {/* Right Section (Image) */}
          <div className="w-1/2 hidden  lg:h-[500px] 2xl:h-[600px] pt-5 lg:pt-10 lg:mt-auto  xl:mt- lg:flex overflow-visible">
            <FadeIn direction="horizontal" style={"h-full w-full flex flex-col-reverse"} duration={0.6} delay={0.2}>
              <div className="slanted-edge-about-image  hidden sm:flex " style={{
                backgroundRepeat: "no-repeat",
                backgroundSize: "100% auto",
                backgroundPosition: "center top",
                backgroundImage: `url(${props.aboutImage})`,
              }}></div>
            </FadeIn>
          </div>
        </div>
      </div>
    </div>
  )
}

function Unique({ content }) {
  const icons = [
    {
      delay: 0.2
    },
    {
      delay: 0.3
    },
    {
      delay: 0.4
    },
    {
      delay: 0.2
    },
    {
      delay: 0.3
    },
    {
      delay: 0.4
    }
  ]

  return (
    <div className="w-full h-full relative text-black font-bold overflow-hidden">
      <div
        className="absolute inset-0 "
        style={{
          backgroundImage: "url('/image/tech_texture.webp')",
          backgroundSize: "cover",
          backgroundPosition: "center",
          opacity: 0.06,
          zIndex: 0
        }}
      />
      <div className="relative z-10 h-full p-10 sm:p-0 flex items-center justify-center">
        <div className="grid grid-cols-3  grid-rows-2   sm:grid-cols-3 sm:grid-rows-2 gap-5 sm:gap-5 lg:gap-10 place-items-center">
          {content.map((item, index) => (
            <FadeIn key={index} direction="up" duration={0.6} delay={icons[index].delay}>
              <div className="flex   h-28  flex-col items-center sm:justify-center ">
                <div className="border-[#1E1E1E] border-[4px] sm:border-4 p-3 sm:p-2 lg:border-[5px] h-16 w-16 sm:w-20 sm:h-20 lg:h-20 lg:w-20 rounded-full flex items-center justify-center bg-white">
                  <img src={`${item.image}`} alt="icon" loading="lazy" className="h-full w-full" />
                </div>
                <h2 className="h3 sm:w-auto text-[#1E1E1E] lg:w-full text-center">{item.name}</h2>
              </div>
            </FadeIn>
          ))}
        </div>
      </div>
    </div>
  )
}

function FeaturedProduct({ content, title }) {
  const [slideIndex] = useAtom(sharedSlideAtom)
  const [, updateSlide] = useAtom(updateSlideAtom)
  const swiperRef = useRef(null)

  const [squareImages, setSquareImages] = useState({}) // Track which idx is square

  const handleImageLoad = (e, idx) => {
    const { naturalWidth, naturalHeight } = e.target
    setSquareImages((prev) => ({
      ...prev,
      [idx]: naturalWidth === naturalHeight,
    }))
  }


  useEffect(() => {
    if (swiperRef.current) {
      swiperRef.current.slideTo(slideIndex)
    }
  }, [slideIndex])

  return (
    <div className="w-full h-full relative flex flex-col md:min-h-[50vh] lg:min-h-[80vh] 3xl:min-h-full justify-between bg-gradient-to-b from-[#0399DB] to-[#ffffff] text-white">
      <div
        className="absolute inset-0 bg-[#0399DB] bg-blend-luminosity"
        style={{
          backgroundImage: "url('/image/tech_texture.webp')",
          backgroundSize: "contain",
          backgroundPosition: "center",
          opacity: 0.1,
          zIndex: 0
        }}
      />
      <div className="absolute inset-0 bg-[#0399DB] opacity-50"></div>

      <div className="flex z-10 flex-row items-center justify-between gap-8 p-5 lg:px-20  ">
        <div className="text-center w-full flex flex-col items-center justify-center">
          <h2 className="h2">{useLang("home.FeaturedProduct.header")}</h2>
          <h3 className="h3 ">{useLang("home.FeaturedProduct.tagline")}</h3>
        </div>
      </div>

      <div className="w-full  lg:px-40  md:px-10 flex flex-col md:flex-row   lg:pt-5   mx-auto  2xl:max-w-[1400px] ">
        <div className="hidden prev-product   md:flex items-center z-10 cursor-pointe ">
          <IoIosArrowBack className="text-3xl  sm:text-5xl lg:text-7xl" />
        </div>
        <Swiper
          onSwiper={(swiper) => (swiperRef.current = swiper)}
          onSlideChange={(swiper) => updateSlide(swiper.activeIndex)}
          effect={"coverflow"}
          grabCursor={true}
          centeredSlides={true}
          slidesPerView={2}
          breakpoints={{
            768: {
              slidesPerView: 3
            },
            1024: {
              slidesPerView: 3
            }
          }}
          initialSlide={slideIndex}
          spaceBetween={0}
          navigation={{
            nextEl: ".next-product",
            prevEl: ".prev-product"
          }}
          coverflowEffect={{
            rotate: 0,
            stretch: 0,
            depth: 100,
            modifier: 2.5,
            slideShadows: false
          }}
          modules={[EffectCoverflow, Navigation]}
          className="  flex-1 flex justify-center "
        >
          {content.map((item, idx) => (
            <SwiperSlide key={idx}>
              <div className="h-56 my-2 w-44 sm:h-64 mx-auto sm:w-52 lg:h-96 lg:w-72 overflow-hidden z-10 rounded-md bg-white lg:rounded-lg p-[1px] sm:p-1 shadow-lg">
                <div className="w-full h-full p-1 sm:p-1 shadow-lg text-center border-[1px] sm:border border-black rounded-[5px] flex flex-col items-center justify-between">
                  <div className="overflow-hidden h-20 flex-1 w-full flex justify-center items-center lg:p-10 p-1">
                    <img
                      src={item.thumbnail}
                      alt={`${item.name}_photo`}

                      onLoad={(e) => handleImageLoad(e, idx)}
                      className={`w-full ${squareImages[idx] ? 'aspect-square' : ''}`}
                    />
                  </div>

                  <div className="h-10 sm:h-10 w-full flex flex-col justify-center">
                    <p className="text-[#0399DB] h3">{item.name}</p>
                  </div>
                </div>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>

        <div className="hidden  next-product md:flex items-center  z-10 cursor-pointer  ">
          <IoIosArrowForward className="text-3xl  sm:text-5xl lg:text-7xl" />
        </div>

        <div className="flex md:hidden pt-2  px-20 justify-between items-center">
          <div className="prev-product  z-10 cursor-pointe ">
            <IoIosArrowBack className="text-3xl  sm:text-5xl lg:text-7xl" />
          </div>
          <div className="next-product   z-10 cursor-pointer  ">
            <IoIosArrowForward className="text-3xl  sm:text-5xl lg:text-7xl" />
          </div>
        </div>
      </div>

      <div className="curve-line-product w-full    bottom-0">
        <div className="curve-line-product-inside overflow-hidden w-full  sm:h-56 md:h-72 p-4 sm:pt-0  lg:h-[350px]  3xl:max-h-[720px] bottom-0">
          {/* <div className=" w-full  sm:h-56 md:h-72 pt-4 sm:pt-0  lg:h-[350px]   bottom-0"> */}
          <div className="w-full py-4 flex flex-col  items-center justify-center md:gap-10 gap-5  sm:pt-16 lg:pt-28">
            <div className="text-black text-justify  ">
              <FeaturedProductDes content={content} />
            </div>
            <a
              href="/product"
              title={`${title}`}
              className="bg-[#0399DB] text-white px-4 py-2 rounded-md h3 hover:bg-white border-2 border-[#0399DB] hover:text-[#0399DB] transition-all duration-200"
            >
              {useLang("home.FeaturedProduct.see-all_button")}
            </a>
          </div>
        </div>
      </div>
    </div>
  )
}

function FeaturedProductDes({ content }) {
  const [slideIndex] = useAtom(sharedSlideAtom)
  const [, updateSlide] = useAtom(updateSlideAtom)
  const swiperRef = useRef(null)

  useEffect(() => {
    if (swiperRef.current) {
      swiperRef.current.slideTo(slideIndex)
    }
  }, [slideIndex])

  const fontSizeStyle = `
      [&_p]:text-black
      [&_p]:p
      [&_p]:text-justify
              `

  return (
    <div className="w-96 px-10  sm:w-full mt-5 lg:mt-0 sm:px-32 lg:px-24 2xl:px-14 lg:w-full  max-w-4xl ">
      <Swiper
        onSwiper={(swiper) => (swiperRef.current = swiper)}
        onSlideChange={(swiper) => updateSlide(swiper.activeIndex)}
        effect={"coverflow"}
        grabCursor={true}
        centeredSlides={true}
        slidesPerView={1}
        initialSlide={slideIndex}
        spaceBetween={200}
        coverflowEffect={{
          rotate: 0,
          stretch: 0,
          depth: 100,
          modifier: 2.5,
          slideShadows: false
        }}
        modules={[EffectCoverflow]}
      >
        {content.map((item, idx) => (
          <SwiperSlide key={idx}>
            <div className={`text-editor-content ${fontSizeStyle} `} dangerouslySetInnerHTML={{ __html: item?.description }} />
          </SwiperSlide>
        ))}
      </Swiper>

      {/* Navigation Arrows */}
    </div>
  )
}

function SellingPoint({ content }) {
  return (
    <div className="w-full h-full bg-[#0399DB] relative text-white ">
      <div
        className="absolute bottom-0 bg-[#0399DB] bg-cover bg-center left-0 w-full h-full bg-blend-multiply bg-fixed"
        style={{ backgroundImage: "url('/image/bg/big-city.webp')" }}
      ></div>
      <div className="absolute top-0 left-0 w-full h-full bg-gradient-to-tr from-[#02374E] to-[#13a2e0] opacity-60"></div>

      <div className="flex flex-col items-center  justify-center h-full relative z-10 px-7 sm:px-14">
        <div className="flex flex-row justify-center items-center my-5  w-full gap-10 lg:my-20 ">
          <div className="h-[1px] sm:h-[2px] flex-1 bg-white"></div>
          <h2 className="h1">{useLang("home.SellingPoint.header")}</h2>
          <div className="h-[1px] sm:h-[2px] flex-1 bg-white"></div>
        </div>

        <div className="flex-1 gap-1 md:gap-2 2xl:gap-5 md:flex pb-5 md:pb-0  md:flex-row grid grid-cols-2 justify-between 3xl:max-h-[540px] ">
          {content.map((point, index) => (
            <FadeIn direction="up" duration={0.6} delay={index * 0.1} key={index}>
              <div className="bg-white bg-opacity-90 px-1 md:px-3 h-full w-full aspect-square md:h-60 p-5   md:w-44 lg:w-72  rounded-md   md:rounded-lg  flex flex-col items-center">
                <div className="flex-1 flex items-center justify-center ">
                  <div className="w-14 h-14 md:w-20 md:h-20 lg:w-24 lg:h-24 rounded-full flex justify-center items-center">
                    <img src={`${point.image}`} alt="icon" loading="lazy" />
                  </div>
                </div>
                <div className="flex-1 flex flex-col items-center justify-center font-bold text-black text-center">
                  <h3 className="h1">
                    +<CountUp from={0} to={point.total} separator="," duration={1} />
                  </h3>
                  <h4 className="h3">{point.name}</h4>
                </div>
              </div>
            </FadeIn>
          ))}
        </div>
      </div>
    </div>
  )
}

function Testimonial({ content }) {
  return (
    <div className="w-full lg:p-10 text-black flex flex-col items-center justify-between lg:justify-center px-3   lg:px-10">
      <div className="flex flex-col  justify-center  p-5 sm:p-5  ">
        <h2 className="h1 text-center">{useLang("home.Testimonial.header")}</h2>
        <p className="p tracking-wide text-center lg:mt-4">{useLang("home.Testimonial.tagline")}</p>
      </div>

      <div className=" w-full  md:px-0 flex-1 gap-2 md:gap-0 flex flex-col md:flex-row items-center justify-center">
        {/* Navigation Buttons */}
        <div className="prev-testimoni hidden md:flex items-center   h-full  z-10 cursor-pointer  ">
          <IoIosArrowBack className=" text-3xl sm:text-5xl lg:text-7xl text-[#0399DB]" />
        </div>

        <Swiper
          spaceBetween={20}
          breakpoints={{
            768: {
              slidesPerView: 1
            },
            1024: {
              slidesPerView: 2.5
            }
          }}
          navigation={{
            nextEl: ".next-testimoni",
            prevEl: ".prev-testimoni"
          }}
          modules={[Navigation, Autoplay]}
          className="w-full "
        >
          {content.map((item, index) => (
            <SwiperSlide key={index}>
              <div className="h-[168px] md:h-[150px] lg:h-[190px] my-5 lg:my-10 sm:w-full lg:w-full rounded-md lg:rounded-lg mx-5  bg-white custom-shadow-strong text-left flex flex-col items-start p-3 sm:p-4 lg:p-5 gap-1 sm:gap-2 lg:gap-2 overflow-hidden">
                <p className="h3">{item.name}</p>
                <p className="p text-justify">{item.message}</p>
              </div>
            </SwiperSlide>
          ))}

          <div className="flex md:hidden  mb-5 py-2 w-full justify-between px-20">
            <div className="prev-testimoni  z-10 cursor-pointer  ">
              <IoIosArrowBack className=" text-3xl sm:text-5xl lg:text-7xl text-[#0399DB]" />
            </div>
            <div className="next-testimoni  z-10 cursor-pointer  ">
              <IoIosArrowForward className="text-3xl sm:text-5xl lg:text-7xl text-[#0399DB]" />
            </div>
          </div>
        </Swiper>

        <div className="next-testimoni hidden md:flex items-center h-full z-10  cursor-pointer  ">
          <IoIosArrowForward className="text-3xl sm:text-5xl lg:text-7xl text-[#0399DB]" />
        </div>
      </div>
    </div>
  )
}

function Article({ content, title }) {
  return (
    <div className=" relative text-black p-5 md:py-10 lg:py-20 lg:px-40  md:px-10 ">
      <div className="absolute inset-0  bg-white m-5 md:my-5 lg:mx-36 lg:my-20 rounded-lg"></div>
      <div className="relative text-center w-full flex items-center justify-between border-b-2 border-black p-5 lg:py-10 ">
        <h2 className="h2 text-black">{useLang("home.Article.header")}</h2>
      </div>

      <div className="relative flex flex-col max-w-screen-xl p-5 md:p-0 flex-1 my-5 w-full gap-1 ">
        {content.map((article, index) => (
          <div key={index}>
            <a
              href={`/blog/${article.slug}`}
              key={index}
              title={`${title}`}
              className=" cursor-pointer mb-7 group border flex-1 w-full flex flex-col md:flex-row md:h-52 lg:h-40  2xl:h-52 rounded-md lg:rounded-xl p-1 lg:p-2 transition-all duration-300"
            >
              {/* Thumbnail */}
              <div className="w-full md:h-full lg:h-auto lg:w-1/4 lg:group-hover:w-0 2xl:group-hover:w-0 transition-all duration-300 aspect-[16/9] md:aspect-auto bg-slate-300 rounded-tl-md rounded-bl-md lg:rounded-tr-none lg:rounded-br-none overflow-hidden">
                <img src={article.thumbnail} alt="article.thumbnail" className="h-full w-full object-cover" />
              </div>

              {/* Content */}
              <div className="w-full lg:w-3/4  flex flex-col p-1 gap-3 md:px-3 transition-all duration-300">
                <h3 className="h3 text-left ">{article.title}</h3>
                <p className="p text-left text-[#7C7C7C] text-ellipsis">{article.short_description}</p>
                <p className="p text-right text-[#7C7C7C] mt-auto">{date(article.published_at)}</p>
              </div>

              {/* Hover Section */}
              <div className="w-0 hidden lg:group-hover:w-1/4 transition-all duration-300 bg-gradient-to-l from-[#a5e4ff] to-transparent lg:flex justify-center items-center rounded-tl-md rounded-bl-md overflow-hidden">
                <p className="opacity-0 lg:group-hover:opacity-100 translate-x-[100%] lg:group-hover:translate-x-0 p font-semibold text-[#0399DB] lg:px-3 lg:py-2 lg:rounded-md transition-all duration-300">
                  {useLang("home.Article.read-all_button")}
                </p>
              </div>
            </a>
          </div>
        ))}

        <div className="flex items-center justify-center w-full mt-5">
          <a
            title={`${title}`}
            href="/blog"
            className="bg-[#0399DB] text-white px-4 py-2 rounded-md h3 hover:bg-white border-2 border-[#0399DB] hover:text-[#0399DB] transition-all duration-200"
          >
            {useLang("home.Article.see-all_button")}
          </a>
        </div>
      </div>
    </div>
  )
}
