import HomeLayout from "@/Layouts/HomeLayout"

import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"
import React from "react"

import "../Home/styles.css"
import CTA from "@/Components/CTA"
import useLang from "@/utlis/useLang"
import FadeIn from "@/Components/animation/FadeIn"
import { Swiper, SwiperSlide } from "swiper/react"
import { useState, useEffect } from "react"

import { EffectCoverflow, Pagination } from "swiper/modules"
import useButtonTitle from "@/utlis/useButtonTitle"
const fontSizeStyle = `
[&_p]:text-[#7C7C7C]
[&_p]:p
[&_p]:text-justify
`
const Index = (props) => {
  let location = props.location
  const title = useButtonTitle()

  const [view, setView] = useState(false)

  return (
    <HomeLayout>
      <div className="flex flex-col items-center text-left justify-center h-[20vh] lg:h-[50vh] max-h-[720px]">
        <Hero props={props} />
      </div>

      <div className="lg:px-40 px-5">
        <h2 className="py-2 lg:py-5  w-full h3  font-normal  border-b border-black text-black">
          <span className="cursor-pointer hover:text-[#0399DB]  font-bold">
            <a title={`${title}`} href="/product">
              {useLang("navbar.product")}
            </a>
          </span>{" "}
          / {props.category.name}
        </h2>

        <FadeIn direction="vertical" style={"py-2 lg:py-5 "} duration={0.6} delay={0.4}>
          <div className={`${view ? "h-fit" : "h-16"} lg:h-fit transition-all duration-300 relative overflow-hidden`}>
            <div
              className={`${view && "translate-y-[100%]"} transition-all lg:hidden duration-200 bg-gradient-to-t h-full w-full from-white top-2 to-transparent absolute`}
            ></div>
            <div className={`text-editor-content ${fontSizeStyle}`} dangerouslySetInnerHTML={{ __html: props.category.description }}></div>
          </div>

          <div className="w-full flex justify-center">
            <button
              onClick={() => setView(!view)}
              className="text-black text-center text-base lg:text-xl lg:hidden transition-all duration-300 hover:scale-105 hover:text-[#0399DB] "
            >
              {" "}
              <i className={`fas fa-chevron-down transition-transform  duration-300 ${view ? "rotate-180" : "rotate-0"}`}></i>
            </button>
          </div>
        </FadeIn>
      </div>

      <div className=" flex flex-col items-center justify-center py-5 lg:py-0  lg:min-h-screen 2xl:min-h-full  ">
        <ProductList content={props.products} location={location} title={title} />
      </div>

      <div className="lg:h-20">
        <PaginationProduct content={props.products} title={title} />
      </div>

      <div className="flex flex-col items-center justify-center mt-10">
        <CTA />
      </div>
    </HomeLayout>
  )
}

export default Index

function Hero({ props }) {
  return (
    <>
      <div
        className="relative w-full h-screen bg-cover bg-center bg-[#0399DB] bg-blend-luminosity "
        style={{
          backgroundImage: "url('/image/bg/Product-hero.png')",
          backgroundPosition: "center"
        }}
      >
        {/* Dark semi-transparent overlay */}
        <div className="absolute inset-0 bg-[#0399DB] opacity-75"></div>
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-50"></div>
        <div className="h-full w-full flex flex-col-reverse px-10 lg:px-40 pb-5 lg:pb-10 z-10 absolute">
          <FadeIn direction="horizontal" duration={0.6} delay={0.2}>
            <h1 className="h1_hero text-white z-10 font-bold ">{props.category.name}</h1>
          </FadeIn>
        </div>

        {/* Your content */}
      </div>
    </>
  )
}

function ProductList({ content, location, title }) {
 
  const url = location
  const cleanUrl = url.split("?")[0]

  const products = content.data

  return (
    <div className="h-full lg:px-40  px-5">
      <div className="lg:py-10 grid grid-cols-2 gap-2 lg:grid-cols-3">
        {products.map((product, index) => (
          <div
            key={index}
            className="bg-white cursor-pointer relative custom-shadow flex border md:border-2 rounded-md border-black  flex-col lg:rounded-lg lg:min-w-60 overflow-hidden"
          >
            <div className="z-10 overflow-hidden bg-white ">
              <Swiper
                effect={"coverflow"}
                grabCursor={true}
                centeredSlides={true}
                slidesPerView={1}
                initialSlide={0}
                spaceBetween={100}
                coverflowEffect={{
                  rotate: 0,
                  stretch: 0,
                  depth: 200,
                  modifier: 2.5,
                  slideShadows: false
                }}
                pagination={{ clickable: true }}
                modules={[EffectCoverflow, Pagination]}
              >
                {product.product_image.map((item, idx) => (
                  <SwiperSlide key={idx}>
                    <img
                      src={item.value}
                      alt={product.title}
                      className="aspect-square overflow-visible w-full object-cover rounded lg:hover:scale-105 transition-all duration-200"
                    />
                  </SwiperSlide>
                ))}
              </Swiper>
            </div>

            <div className="flex-1 w-full h2 z-10 md:p-2 flex flex-col gap-1 lg:gap-3  lg:min-h-10 text-black p-1">
              <p className="h2 text-black text-center flex justify-center items-center">{product.brand.name}</p>
              <p className="p text-black text-center flex justify-center items-center">{product.name}</p>
              <a
                title={`${title}`}
                href={`${cleanUrl}/${product.slug}`}
                className="h3  font-bold bg-[#0399DB] text-white py-1 rounded-[3px] md:py-2 lg:rounded-md lg:hover:bg-white lg:hover:text-[#0399DB] lg:border-2 lg:border-[#0399DB] text-center flex justify-center items-center cursor-pointer transition-all duration-200  "
              >
                {useLang('product.show.button')}
              </a>
            </div>
          </div>
        ))}
      </div>
    </div>
  )
}

function PaginationProduct({ content, title }) {
  const [pageWindowStart, setPageWindowStart] = useState(0)
  const pageWindowSize = 5

  const currentPage = content.current_page

  // Get only the page number links (skip prev/next)
  const pageLinks = content.links.slice(1, content.links.length - 1)

  // Move the window if currentPage is outside visible range
  useEffect(() => {
    const currentIndex = pageLinks.findIndex((link) => link.label == currentPage)
    if (currentIndex < pageWindowStart || currentIndex >= pageWindowStart + pageWindowSize) {
      setPageWindowStart(Math.max(0, currentIndex - 2)) // center current
    }
  }, [currentPage])

  const visibleLinks = pageLinks.slice(pageWindowStart, pageWindowStart + pageWindowSize)

  return (
    <div className="h-full w-full flex justify-center items-center text-black">
      <div className="flex lg:gap-2 items-center">
        {/* Prev Button (first index) */}
        <a
          title={`${title}`}
          href={content.links[0].url || "#"}
          className={`flex justify-center px-3 items-center rounded-sm cursor-pointer bg-[#0399DB] shadow-md hover:bg-white border md:border-2 border-[#0399DB] hover:text-[#0399DB] transition-all duration-300 text-white md:p-2 lg:rounded-md font-semibold ${
            content.current_page === 1 ? "opacity-50 pointer-events-none" : ""
          }`}
          dangerouslySetInnerHTML={{ __html: content.links[0].label }}
        />

        {/* Visible Page Numbers */}
        {visibleLinks.map((link, index) => (
          <a
            title={`${title}`}
            href={link.url || "#"}
            key={index}
            className={`p flex justify-center px-2 md:px-3 items-center rounded-sm cursor-pointer hover:text-[#0399DB] ${
              link.active ? " text-[#0399DB] font-bold scale-125" : ""
            }`}
            dangerouslySetInnerHTML={{ __html: link.label }}
          />
        ))}

        {/* Next Button (last index) */}
        <a
          title={`${title}`}
          href={content.links[content.links.length - 1].url || "#"}
          className={`flex justify-center px-3 items-center rounded-sm cursor-pointer bg-[#0399DB] shadow-md hover:bg-white border md:border-2 border-[#0399DB] hover:text-[#0399DB] transition-all duration-300 text-white md:p-2 lg:rounded-md font-semibold ${
            content.current_page === content.last_page ? "opacity-50 pointer-events-none" : ""
          }`}
          dangerouslySetInnerHTML={{
            __html: content.links[content.links.length - 1].label
          }}
        />
      </div>
    </div>
  )
}
