import HomeLayout from "@/Layouts/HomeLayout"

import "swiper/css"
import "swiper/css/pagination"
import "swiper/css/navigation"
import React, { useState } from "react"
import { RiCustomerServiceLine } from "react-icons/ri"

import "../Home/styles.css"
import CTA from "@/Components/CTA"
import useLang from "@/utlis/useLang"

import { Swiper, SwiperSlide } from "swiper/react"

import { Autoplay, EffectCoverflow, FreeMode, Navigation, Pagination, Thumbs } from "swiper/modules"
import { router, usePage } from "@inertiajs/react"
import { whatsappNumber } from "@/utlis/format"
import UserChatModal from "@/Components/Default/UserChatModal"
import useButtonTitle from "@/utlis/useButtonTitle"

const Index = (props) => {
  let location = props
  const title = useButtonTitle()

  return (
    <HomeLayout>
      <div className="flex flex-col items-center justify-center h-[15vh] md:h-[20vh] lg:h-[50vh] max-h-[720px]">
        <Hero />
      </div>

      <div className="lg:px-40 px-5">
        <h2 className="py-2 lg:py-5 w-full h3 border-b border-black text-black">
          <span className="cursor-pointer hover:text-[#0399DB] font-bold">
            <a title={`${title}`} href="/product">
              {useLang("navbar.product")}
            </a>
          </span>{" "}
          /{" "}
          <span className="cursor-pointer hover:text-[#0399DB] font-bold ">
            <a title={`${title}`} href={`/product/${props.category.slug}`}>
              {props.category.name}
            </a>
          </span>{" "}
          / {props.product.brand.name} {props.product.name}
        </h2>
      </div>

     

      <div className=" flex flex-col items-center justify-center  lg:min-h-screen 2xl:min-h-full ">
        <ProductDetail content={props.product} location={location} />
      </div>

      <div className="flex flex-col items-center justify-center lg:mt-20">
        <CTA />
      </div>
    </HomeLayout>
  )
}

export default Index

function Hero() {
  return (
    <>
      <div
        className="relative w-full h-screen bg-fixed bg-contain  bg-no-repeat lg:bg-cover lg:bg-center bg-[#0399DB] bg-blend-luminosity "
        style={{
          backgroundImage: "url('/image/bg/Product-hero.png')"
          // backgroundPosition: "center"
        }}
      >
        {/* Dark semi-transparent overlay */}
        <div className="absolute inset-0 bg-[#187ba5] opacity-75"></div>
        <div className="absolute inset-0 bg-gradient-to-b from-black to-transparent opacity-60"></div>

        {/* Your content */}
      </div>
    </>
  )
}

function ProductDetail({ content, location }) {
  const fontSizeStyle = `
    [&]:text-black
    [&_table]:p
    [&_table]:w-full
    [&_td]:col-span-1
    [&_p]:p
    [&_p]:text-justify
  `

  const [thumbsSwiper, setThumbsSwiper] = useState(null)
  const [activeIndex, setActiveIndex] = useState(0)

  const { props } = usePage()
  const handleAction = () => {
    const action = props?.config?.CTA_ACTION
    if (action === "whatsapp" && props?.config?.CTA_FORM) {
      window.open(`https://wa.me/${whatsappNumber(props?.config?.CTA_FORM)}`, "_blank")
      return
    }

    window.location.href = `/contact`
  }

  return (
    <div className="h-full w-full lg:py-5 lg:px-40 flex flex-col md:flex-row">
      <div className="h-full md:w-40 flex-1 p-5 gap-2 lg:gap-2 lg:p-0  lg:px-10 2xl:px-40 flex flex-col">
        <div className="flex flex-col">
          <h2 className="h2 text-black font-bold ">{content.brand.name}</h2>
          <h3 className="h2 text-black  ">{content.name}</h3>
        </div>

        <div className="w-full aspect-square rounded-md border-2 overflow-hidden bg-white">
          <Swiper
            spaceBetween={10}
            slidesPerView={1}
            loop={true}
            autoplay={{
              delay: 4000,
              disableOnInteraction: false
            }}
            thumbs={{ swiper: thumbsSwiper }}
            modules={[FreeMode, Navigation, Thumbs, Autoplay]}
            onSlideChange={(swiper) => setActiveIndex(swiper.realIndex)}
          >
            {content.product_image.map((Item, index) => (
              <SwiperSlide key={index} className={"rounded-md overflow-hidden"}>
                <img src={`${Item.value}`} alt={`${Item.label}`} className="w-full h-full  rounded-md overflow-hidden object-cover" />
              </SwiperSlide>
            ))}
          </Swiper>
        </div>

        <div className="flex lg:h-1/5 items-center justify-between">
          <Swiper onSwiper={setThumbsSwiper} loop={true} spaceBetween={10} slidesPerView={3} watchSlidesProgress={true} modules={[Navigation]}>
            {content.product_image.map((Item, index) => (
              <SwiperSlide key={index}>
                <div className="relative rounded-md  ">
                  <img
                    src={`${Item.value}`}
                    alt={`${Item.label}`}
                    className="border-2 rounded-md bg-white object-cover  cursor-pointer w-full aspect-square"
                  />

                  <div
                    className={`
                      absolute inset-0 bg-black z-10 rounded-md
                      transition-opacity duration-300
                      ${index === activeIndex ? "opacity-50" : "opacity-0"}
                      pointer-events-none
                    `}
                  ></div>
                </div>
              </SwiperSlide>
            ))}
          </Swiper>
        </div>
      </div>

      {/* ==========================================   */}

      <div className="h-full w-full flex flex-col p-5 lg:p-0 md:w-1/2 lg:w-2/5">
        <div className="lg:h-20 flex items-center "></div>
        <div className={`text-editor-content ${fontSizeStyle}`} dangerouslySetInnerHTML={{ __html: content.description }}></div>
        <div className="flex text-base flex-col flex-1 gap-3 lg:gap-3 lg:p-3 items-center justify-center">
          <p className="text-black p">{useLang("product.show.order_now")}</p>

          {props?.config?.CTA_ACTION === "chat" && !!props?.config?.CS_CHAT ? (
            <UserChatModal
              ModalButton={() => (
                <>
                  <button
                    aria-label="chat"
                    type="button"
                    className="text-white flex gap-1 lg:gap-2 h3 border-2 border-[#0399DB] bg-[#0399DB] hover:text-[#0399DB] hover:scale-105 transition-all hover:bg-white p-2 lg:p-2 lg:px-4 rounded-full duration-300"
                  >
                    <RiCustomerServiceLine className="text-xl lg:text-2xl" />
                    {useLang("product.show.contact_button")}
                  </button>
                </>
              )}
            />
          ) : (
            <button
              onClick={handleAction}
              className="text-white flex gap-1 lg:gap-2 h3 border-2 border-[#0399DB] bg-[#0399DB] hover:text-[#0399DB] hover:scale-105 transition-all hover:bg-white p-2 lg:p-2 lg:px-4 rounded-full duration-300"
            >
              <RiCustomerServiceLine className="text-xl lg:text-2xl" />
              {useLang("product.show.contact_button")}
            </button>
          )}
        </div>
      </div>
    </div>
  )
}
