import useFormChange from '@/utlis/useFormChange';
import { useForm, usePage } from '@inertiajs/react'
import { useCallback, useMemo } from 'react';

function useFormBuilder({ isEdit = false, getProperties, onChange = null, onSubmit = null, initialData = {} }) {
  const { props } = usePage()
  let { page } = props

  if (isEdit) {
    page.data = props[page?.name]
  }

  let initialFormData = {}
  for (const field of page?.fields) {
    const valueFromData = page?.data?.[field.name];
    initialFormData[field.name] = valueFromData ?? field.defaultValue ?? '';
  }

  initialFormData = {...initialFormData, ...initialData}
  
  const form = useForm({
    ...initialFormData,
    ref_url: props.location,
  });

  const { data, setData, post, put, errors } = form

  const handleChange = (e) => {
    if (onChange) return onChange(e, data, setData)
    const { name, value } = useFormChange(e, data);

    setData((state) => ({
      ...state,
      [name]: value,
    }));
  }

  const handleSubmit = (e) => {
    e?.preventDefault();
    if (onSubmit) return onSubmit(e, form)

    if (page?.data) {
      data._method = 'put'
      let id = page?.data?.id
      if (!id && page?.data?.id_id) {
        id = page?.data?.id_id
      }
      if (!id && page?.data?.id_en) {
        id = page?.data?.id_en
      }
      return post(`${page?.url}/${id}`);
    }
    return post(`${page?.url}`);
  };

  const inputProps = { data, errors, handleChange }
  const properties = useMemo(() => (
    getProperties({ ...inputProps, setData, props, isEdit })
  ), [data, errors, handleChange, onChange, isEdit, getProperties])


  return { form, properties, inputProps, handleChange, handleSubmit }
}

export default useFormBuilder
