import { usePage } from "@inertiajs/react"
import { useStatusLabel } from "./useStatus"
import { jsonParse } from "./format"

const configurationLang = {
  "CTA_ACTION": "Jenis CTA",
  "CTA_FORM": "Form CTA",
  "GTM_ID": "ID Google Tag Manager",
  "GOOGLE_VERIFICATION": "Kode Google Search Verification",
  "CS_CHAT": "Chat Customer Service",
}

const langs = {
  ...configurationLang,
  Admin: "Admin",
  show: "Tampilkan",
  hidden: "Sembunyikan",
  "transaction.type.expenditure": "Pemakaian Anggaran",
  "transaction.type.refund": "Pengembalian Dana",
  "transaction.type.advance": "Kasbon",
  "budget.type.new": "Anggaran Baru",
  "budget.type.credit": "Pengurangan Anggaran",
  "budget.type.revision": "Anggaran Revisi",

  "report.budget": "Per Anggaran",
  "report.category": "Per Kategori",
  "report.division": "Per Divisi",
  "lang.id": "Indonesia",
  "lang.en": "Inggris",

  "category.product": "Produk Unggulan",
  "category.after-sales": "Purna Jual",

  "banner.image": "Gambar",
  "banner.video": "Video",
  
  "profile.companyName": "Nama Perusahaan",
  "profile.tagline": "Tagline",
  "profile.email": "Email",
  "profile.phone": "Telepon",
  "profile.whatsapp": "Whatsapp",
  "profile.facebook": "Facebook",
  "profile.instagram": "Instagram",
  "profile.youtube": "Youtube",
  "profile.officeAddress": "Office Address",
  "profile.warehouseAddress": "Warehouse Address",
  "profile.addressMap": "Address Map",
  "profile.about": "Tentang Perusahaan",
  "profile.location": "Lokasi Perusahaan",
  "profile.foundedYear": "Tahun Berdiri",
  "profile.vision": "Visi",
  "profile.mission": "Misi",
  "profile.marketSegment": "Market Segment",
  "profile.marketSegmentList": "Daftar Market Segment",
  "profile.requirementAfterSales": "Ketentuan Purna Jual",
  "profile.seoKeywords": "SEO Keyword",
  "profile.seoDescription": "SEO Description",
  "profile.aboutImage": "About Image",

  "seo.default": "Default",
  "seo.about": "Tentang Kami",
  "seo.career": "Karir",
  "seo.gallery": "Galeri",
  "seo.afterSales": "Layanan Purna Jual",
  "seo.blogIndex": "Blog",
  "seo.contactIndex": "Hubungi Kami",
  "seo.categoryIndex": "Produk Unggulan",
  "seo.productIndex": "Produk",
}
function useLang(string, pageProps = null) {
  if (!string) return ''  

  let translation = getTranslation(pageProps)
  const translations = { ...translation, ...langs }
  return translations[string] ?? useStatusLabel(string) ?? string
}

const getTranslation = (props) => {
  if (!props) {
    props = usePage().props
  }
  const { lang_translation, lang } = props
  let contents = jsonParse(lang_translation?.content)

  if (!contents) {
    contents = {}
  }

  const defaultLang = "id"

  let jsonContent = {}
  const allTranslations = import.meta.glob("@/locales/**/*.json", { eager: true })
  let matchPath = Object.keys(allTranslations).find((path) => path.includes(`/${lang}/`))

  if (!matchPath) {
    matchPath = Object.keys(allTranslations).find((path) => path.includes(`/${defaultLang}/`))
  }

  if (matchPath) {
    jsonContent = allTranslations[matchPath].default
  }

  contents = { ...jsonContent, ...contents }
  return contents
}

export default useLang
