<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    @if (isset($isPDF))        
    <link href="https://fonts.googleapis.com/css2?family=Ma+Shan+Zheng&family=Noto+Sans+SC&display=swap" rel="stylesheet">
    @endif

    <style>
      thead th {
        text-align: left;
      }
    </style>
</head>
<body>
  <table>
    <thead>
    <tr>
        <th>Tanggal</th>
        <th>Pengeluaran</th>
        <th>Budget</th>
        <th>Keterangan</th>
    </tr>
    </thead>
    <tbody>
    @foreach($transactions as $transaction)
        <tr>
            <td style="width: 100px; font-size: 12px;">{{ date('d-m-Y', $transaction->date) }}</td>
            <td style="width: 100px; font-size: 12px;">{{ number_format($transaction->debit_amount,0,'.',',') }}</td>
            <td style="width: 100px; font-size: 12px;">{{ number_format($transaction->credit_amount,0,'.',',') }}</td>
            <td style="width: 150px; font-size: 12px;">{{ decrypt($transaction->description) }}</td>
        </tr>
    @endforeach
    </tbody>
</table>
</body>
</html>